package cn.gtmap.estateplat.core.encrypt.impl;


import cn.gtmap.estateplat.core.encrypt.AbstractEncryptService;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.security.GeneralSecurityException;

/**
 * 
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version V1.0, 2017-08-03
 * @description AES加密算法
 */
public class AESEncryptServiceImpl extends AbstractEncryptService {
    @Override
    protected Cipher initEncryptCipher(byte[] key) throws GeneralSecurityException {
        SecretKeySpec skeySpec = new SecretKeySpec(key, getMethod());
        Cipher cipher = Cipher.getInstance(getMethod());
        cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
        return cipher;
    }

    @Override
    protected Cipher initDecryptCipher(byte[] key) throws GeneralSecurityException {
        SecretKeySpec skeySpec = new SecretKeySpec(key, getMethod());
        Cipher cipher = Cipher.getInstance(getMethod());
        cipher.init(Cipher.DECRYPT_MODE, skeySpec);
        return cipher;
    }

    @Override
    public String getMethod() {
        return "AES";
    }
}
