package cn.gtmap.estateplat.core.encrypt;


import cn.gtmap.estateplat.utils.Codecs;
import org.springframework.beans.factory.InitializingBean;

import javax.crypto.Cipher;
import java.security.GeneralSecurityException;

/**
 * 
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version V1.0, 2017-08-03
 */
public abstract class AbstractEncryptService implements EncryptService, InitializingBean {

    private String key;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private String encryptKey;
    private String decryptKey;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEncryptKey() {
        return encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public String getDecryptKey() {
        return decryptKey;
    }

    public void setDecryptKey(String decryptKey) {
        this.decryptKey = decryptKey;
    }

    @Override
    public String encrypt(String str) {
        return Codecs.encode(encrypt(Codecs.bytes(str)));
    }

    @Override
    public String decrypt(String str) {
        return Codecs.string(decrypt(Codecs.decode(str)));
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        if (encryptCipher == null) {
            throw new IllegalStateException("EncryptCipher not init");
        }
        try {
            return encryptCipher.doFinal(bytes);
        } catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        if (decryptCipher == null) {
            throw new IllegalStateException("DecryptCipher not init");
        }
        try {
            return decryptCipher.doFinal(bytes);
        } catch (Exception e) {
            throw new EncryptException(e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (encryptKey == null) {
            encryptKey = key;
        }
        if (decryptKey == null) {
            decryptKey = key;
        }
        if (encryptKey != null) {
            encryptCipher = initEncryptCipher(Codecs.decode(encryptKey));
        }
        if (decryptKey != null) {
            decryptCipher = initDecryptCipher(Codecs.decode(decryptKey));
        }
    }

    protected abstract Cipher initEncryptCipher(byte[] key) throws GeneralSecurityException;

    protected abstract Cipher initDecryptCipher(byte[] key) throws GeneralSecurityException;
}
