package cn.gtmap.estateplat.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2022/12/6
 * @description 跨站点请求伪造 CSRF攻击过滤器
 */
public class CsrfFilter implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private String[] verifyReferer = null;

    private String invalidPage = "/common/404.ftl";

    @Override
    public void destroy() {

    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        String referer = request.getHeader("Referer");
        boolean b = false;
        for (String vReferer : verifyReferer) {
            if (referer == null || referer.trim().startsWith(vReferer)) {
                b = true;
                chain.doFilter(request, response);
                break;
            }
        }
        if (!b) {
            // 重定向或跳转
            response.sendRedirect(request.getContextPath() + this.invalidPage);
            logger.error("疑似CSRF攻击，referer:" + referer);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String referer = filterConfig.getInitParameter("referer");
        this.verifyReferer = referer.split(",");
    }
}
