package cn.gtmap.estateplat.filter;

import cn.gtmap.estateplat.utils.ClientInfoUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @description 存在跨站漏洞、连接注入过滤器
 */
public class XssFilter implements Filter {
    //白名单页面
    private Map<String, String> whitePageList = new HashMap();
    //白名单ip
    private Map<String, String> whiteIpList = new HashMap();

    private String invalidPage = "/common/404.ftl";

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res,
                         FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        response.addHeader("x-frame-options", "SAMEORIGIN");
        String currentURL = request.getRequestURI();
        String ip = ClientInfoUtil.getIpAddr(request);
        //过滤ip地址
        if (MapUtils.isNotEmpty(whiteIpList)) {
            //不需要过滤的特定页面
            if (MapUtils.isNotEmpty(whitePageList)) {
                String targetURL = currentURL.substring(currentURL.lastIndexOf("/") + 1, currentURL.length());
                if (whitePageList.containsKey(targetURL)) {
                    chain.doFilter(request, response);
                    return;
                }
            }
            if (whiteIpList.containsKey(ip)) {
                chain.doFilter(new XssHttpServletRequestWrapper(request), response);
            } else {
                response.sendRedirect(request.getContextPath() + this.invalidPage);
            }
        } else {
            chain.doFilter(new XssHttpServletRequestWrapper(request), response);
        }
    }

    @Override
    public void init(FilterConfig config) {

        String whitePage = config.getInitParameter("WhitePageList");
        if (StringUtils.isNotBlank(whitePage)) {
            String[] arrPage = whitePage.split(";");
            if (ArrayUtils.isNotEmpty(arrPage)) {
                for (int i = 0; i < arrPage.length; i++) {
                    String key = arrPage[i];
                    this.whitePageList.put(key, (String) null);
                }
            }
        }
        String whiteIp = config.getInitParameter("WhiteIpList");
        if (StringUtils.isNotBlank(whiteIp)) {
            String[] arrIp = whiteIp.split(";");
            if (ArrayUtils.isNotEmpty(arrIp)) {
                for (int i = 0; i < arrIp.length; i++) {
                    String key = arrIp[i];
                    this.whiteIpList.put(key, (String) null);
                }
            }
        }
    }
}
