package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleFourAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 土地经营权
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "QLF_QL_TDJYQ")
@Table(name = "QLF_QL_TDJYQ")
public class QlfQlTdjyq implements Serializable, AccessData {
    final static String ysdm = "6002020410";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String qllx;//权利类型
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String qdfs;//经营权取得方式
    private String cbfdmfbfdm;//承包方代码|发包方代码
    private String cbfdbfbfqc;//承包方代表|发包方全称
    private Double tdlzmj;//土地流转（承包）面积（亩）
    private Date lzqssj;//流转（承包）起始时间
    private Date lzjssj;//流转（承包）结束时间
    private String lzqx;//流转（承包）期限
    private Double lzjg;//流转价格（承包费）（万元）
    private String bdcqzh;//不动产权证号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    private String yt;//土地用途
    private String htdm;//合同代码
    private String ytmc;//土地用途名称
    private String qlxz;//权利性质
    /**
     * 插入更新时间
     *
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**
     * 插入创建时间
     *
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "QLLX")
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "YT")
    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    @XmlAttribute(name = "HTDM")
    public String getHtdm() {
        return htdm;
    }

    public void setHtdm(String htdm) {
        this.htdm = htdm;
    }

    @XmlAttribute(name = "BDCQZH")
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }

    @XmlAttribute(name = "QDFS")
    public String getQdfs() {
        return qdfs;
    }

    public void setQdfs(String qdfs) {
        this.qdfs = qdfs;
    }

    @XmlAttribute(name = "CBFDMFBFDM")
    public String getCbfdmfbfdm() {
        return cbfdmfbfdm;
    }

    public void setCbfdmfbfdm(String cbfdmfbfdm) {
        this.cbfdmfbfdm = cbfdmfbfdm;
    }

    @XmlAttribute(name = "CBFDBFBFQC")
    public String getCbfdbfbfqc() {
        return cbfdbfbfqc;
    }

    public void setCbfdbfbfqc(String cbfdbfbfqc) {
        this.cbfdbfbfqc = cbfdbfbfqc;
    }

    @XmlAttribute(name = "TDLZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getTdlzmj() {
        return tdlzmj;
    }

    public void setTdlzmj(Double tdlzmj) {
        this.tdlzmj = tdlzmj;
    }

    @XmlAttribute(name = "LZQSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getLzqssj() {
        return lzqssj;
    }

    public void setLzqssj(Date lzqssj) {
        this.lzqssj = lzqssj;
    }

    @XmlAttribute(name = "LZJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getLzjssj() {
        return lzjssj;
    }

    public void setLzjssj(Date lzjssj) {
        this.lzjssj = lzjssj;
    }

    @XmlAttribute(name = "LZQX")
    public String getLzqx() {
        return lzqx;
    }

    public void setLzqx(String lzqx) {
        this.lzqx = lzqx;
    }

    @XmlAttribute(name = "LZJG")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getLzjg() {
        return lzjg;
    }

    public void setLzjg(Double lzjg) {
        this.lzjg = lzjg;
    }

    @XmlAttribute(name = "YTMC")
    public String getYtmc() {
        return ytmc;
    }

    public void setYtmc(String ytmc) {
        this.ytmc = ytmc;
    }

    @XmlAttribute(name = "QLXZ")
    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
}
