package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 登记缮证信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "DJF_DJ_SZ")
public class DjfDjSz implements Serializable, AccessData {
    final static String ysdm = "6004060000";//要素代码
    private String ywh;//业务号
    private String szmc;//缮证名称
    private String szzh;//缮证证号
    private String ysxlh;//印刷序列号
    private String szry;//缮证人员
    private Date szsj;//缮证时间
    private String bz;//备注
    private String qxdm;//区县代码

    /**
     * 插入更新时间
     *
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**
     * 插入创建时间
     *
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    /**
     * 插入权利类型
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String qllx;
    /**
     * 插入权利类型名称
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String qllxmc;
    /**
     * 插入权利性质
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String qlxz;
    /**
     * 插入权利性质名称
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String qlxzmc;
    /**
     * 插入房屋用途名称
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String fwytmc;
    /**
     * 插入共有方式
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String gyfs;
    /**
     * 插入附记
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String fj;
    /**
     * 插入权利其他状况
     *
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description
     */
    private String qlqtzk;

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "SZMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSzmc() {
        return szmc;
    }

    public void setSzmc(String szmc) {
        this.szmc = szmc;
    }

    @XmlAttribute(name = "SZZH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSzzh() {
        return szzh;
    }

    public void setSzzh(String szzh) {
        this.szzh = szzh;
    }

    @XmlAttribute(name = "YSXLH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getYsxlh() {
        return ysxlh;
    }

    public void setYsxlh(String ysxlh) {
        this.ysxlh = ysxlh;
    }

    @XmlAttribute(name = "SZRY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getSzry() {
        return szry;
    }

    public void setSzry(String szry) {
        this.szry = szry;
    }

    @XmlAttribute(name = "SZSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getSzsj() {
        return szsj;
    }

    public void setSzsj(Date szsj) {
        this.szsj = szsj;
    }

    @XmlAttribute(name = "BZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlTransient
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlTransient
    public String getQllxmc() {
        return qllxmc;
    }

    public void setQllxmc(String qllxmc) {
        this.qllxmc = qllxmc;
    }

    @XmlTransient
    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    @XmlTransient
    public String getQlxzmc() {
        return qlxzmc;
    }

    public void setQlxzmc(String qlxzmc) {
        this.qlxzmc = qlxzmc;
    }

    @XmlTransient
    public String getFwytmc() {
        return fwytmc;
    }

    public void setFwytmc(String fwytmc) {
        this.fwytmc = fwytmc;
    }

    @XmlTransient
    public String getGyfs() {
        return gyfs;
    }

    public void setGyfs(String gyfs) {
        this.gyfs = gyfs;
    }

    @XmlTransient
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlTransient
    public String getQlqtzk() {
        return qlqtzk;
    }

    public void setQlqtzk(String qlqtzk) {
        this.qlqtzk = qlqtzk;
    }
}
