package cn.gtmap.estateplat.utils;


import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;

/**
 * @author hqz
 * @version 1.0, 2017/8/25
 * @description RSA加密工具类生成海洋局访问token
 */
public class RSAEncryptUtil {

    private static final int MAXENCRYPTSIZE = 117;


    /**
     * 根据公钥、摸、用户名请求日期进行加密
     * @param modulusStr 模数
     * @param exponentStr 指数
     * @param strMsg 待加密的字串
     * @return 加密后的字符串
     */
    public static String encryptStr( String modulusStr, String exponentStr, String strMsg){
        String strResult = "";
        try {
            PublicKey publicKey = getRSAPublidKeyBybase64(modulusStr,exponentStr);
            strResult = encrypt(strMsg,publicKey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return strResult;
    }

    /**
     * 具体的加密方法
     * @param strMsg 待加密的字串
     * @param publicKey 公钥
     * @return 加密后的字串
     * @throws Exception
     */
    private static String encrypt(String strMsg, PublicKey publicKey) throws Exception {
        String encryptData = "";
        byte[] source = strMsg.getBytes(Charset.forName("utf-8"));
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            int length = source.length;
            int offset = 0;
            byte[] cache;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            int i = 0;
            while (length - offset > 0) {
                if (length - offset > MAXENCRYPTSIZE) {
                    cache = cipher.doFinal(source, offset, MAXENCRYPTSIZE);
                } else {
                    cache = cipher.doFinal(source, offset, length - offset);
                }
                outStream.write(cache, 0, cache.length);
                i++;
                offset = i * MAXENCRYPTSIZE;
            }
            return encodeBase64(outStream.toByteArray());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return encryptData;
    }


    /**
     * 根据指数和模数生成公钥
     * @param modulusStr 模数
     * @param exponentStr 指数
     * @return
     * @throws Exception
     */
    private static PublicKey  getRSAPublidKeyBybase64(String modulusStr,String exponentStr) throws Exception{
        byte[] m = decodeBase64(modulusStr);
        byte[] e = decodeBase64(exponentStr);
        BigInteger modulus = new BigInteger(m);
        BigInteger exponent = new BigInteger(e);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(publicKeySpec);
    }

    private static byte[] decodeBase64(String input) throws Exception {
        return Base64.decode(input);
    }

    private static String encodeBase64(byte[] input) throws Exception {
        return Base64.encode(input);
    }


}
