package cn.gtmap.estateplat.model.server.core;

import java.util.Date;

/**
 * .
 * <p/>
 * 权利类型对象接口
 *
 * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
 * @version V1.0, 15-3-20
 */
public interface QllxVo extends InsertVo{

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param
     * @return 不动产登记项目ID
     * @description 获取不动产登记项目ID
     */
    String getProid();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param proid 不动产登记项目ID
     * @return
     * @description 设置不动产登记项目ID
     */

    void setProid(String proid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param
     * @return 不动产登记权利ID
     * @description 获取不动产登记权利ID
     */
    String getQlid();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param qlid 不动产登记权利ID
     * @return
     * @description 设置不动产登记权利ID
     */

    void setQlid(String qlid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param ywh 业务号
     * @return
     * @description 设置不动产登记项目业务号
     */
    void setYwh(String ywh);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param
     * @return
     * @description 设置不动产登记权利相关的不动产单元ID
     */

    String getBdcdyid();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param bdcdyid 不动产单元ID
     * @return
     * @description 设置不动产登记权利相关的不动产单元ID
     */
    void setBdcdyid(String bdcdyid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param qllx 权利类型值，其值参考BDC_ZD_QLLX字典表
     * @return
     * @description 设置不动产登记权利的权利类型
     */
    void setQllx(String qllx);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param
     * @return 权属状态
     * @description 设置不动产登记权利权属状态，其值参考BDC_ZD_QSZT字典表
     */

    Integer getQszt();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param qszt 权属状态
     * @return
     * @description 设置不动产登记权利权属状态，其值参考BDC_ZD_QSZT字典表
     */

    void setQszt(Integer qszt);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param dbr 登簿人
     * @return
     * @description 设置不动产登记权利登簿人
     */
    void setDbr(String dbr);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param
     * @return 登簿人
     * @description 获取不动产登记权利登簿人
     */
    String getDbr();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param
     * @return 登簿时间
     * @description 获取不动产登记权利登簿时间
     */
    Date getDjsj();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param djsj 登簿时间
     * @return
     * @description 设置不动产登记权利登簿时间
     */
    void setDjsj(Date djsj);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param
     * @return 附记信息
     * @description 获取不动产登记权利附记信息
     */
    String getFj();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param fj 附记信息
     * @return
     * @description 设置不动产登记权利附记信息
     */
    void setFj(String fj);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param qlqssj 权利起始时间
     * @return
     * @description 设置不动产登记权利起始时间
     */

    void setQlqssj(Date qlqssj);


    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @return
     * @description 获取不动产登记权利起始时间
     */

    Date getQlqssj();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param qljssj 权利结束时间
     * @return
     * @description 设置不动产登记权利起始时间
     */

    void setQljssj(Date qljssj);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @return
     * @description 获取不动产登记权利结束时间
     */

    Date getQljssj();

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param gyqk 共有情况
     * @return
     * @description 设置不动产登记权利共有情况
     */

    void setGyqk(String gyqk);

    /**
     * @author <a href="mailto:yanzhenkun@gtmap.cn">yanzhenkun</a>
     * @param gyqk 权利其他状况
     * @return
     * @description 设置不动产登记权利其他状况
     */

    void setQlqtzk(String gyqk);

    /**
     * @author <a href="mailto:yanzhenkun@gtmap.cn">yanzhenkun</a>
     * @return
     * @description 获取不动产登记权利其他状况
     */

    String getQlqtzk();

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @return
     * @description 获取撤销状态 1：已撤销,0或空：未撤销
     */
    Integer getCxzt();

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @return
     * @description 设置撤销状态 1：已撤销,0或空：未撤销
     */
    void setCxzt(Integer cxzt);

}
