package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 登记归档信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "DJF_DJ_GD")
@Table(name = "DJF_DJ_GD")
public class DjfDjGdNew implements Serializable, AccessData {
    final static String ysdm = "6004080000";//要素代码
    private String ywh;//业务号
    private String djdl;//登记大类
    private String djxl;//登记小类
    private String zl;//坐落
    private String qzhm;//权证号码
    private Integer wjjs;//文件件数
    private Integer zys;//总页数
    private String gdry;//归档人员
    private Date gdsj;//归档时间
    private String bz;//备注
    private String qxdm;//区县代码
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    private String dah;
    private String dacfjbm;
    @XmlAttribute(name = "DAH")
    public String getDah() {
        return dah;
    }

    public void setDah(String dah) {
        this.dah = dah;
    }
    @XmlAttribute(name = "DACFJBM")
    public String getDacfjbm() {
        return dacfjbm;
    }

    public void setDacfjbm(String dacfjbm) {
        this.dacfjbm = dacfjbm;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "DJDL")
    public String getDjdl() {
        return djdl;
    }

    public void setDjdl(String djdl) {
        this.djdl = djdl;
    }

    @XmlAttribute(name = "DJXL")
    public String getDjxl() {
        return djxl;
    }

    public void setDjxl(String djxl) {
        this.djxl = djxl;
    }

    @XmlAttribute(name = "ZL")
    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    @XmlAttribute(name = "QZHM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQzhm() {
        return qzhm;
    }

    public void setQzhm(String qzhm) {
        this.qzhm = qzhm;
    }

    @XmlAttribute(name = "WJJS")
    public Integer getWjjs() {
        return wjjs;
    }

    public void setWjjs(Integer wjjs) {
        this.wjjs = wjjs;
    }

    @XmlAttribute(name = "ZYS")
    public Integer getZys() {
        return zys;
    }

    public void setZys(Integer zys) {
        this.zys = zys;
    }

    @XmlAttribute(name = "GDRY")
    public String getGdry() {
        return gdry;
    }

    public void setGdry(String gdry) {
        this.gdry = gdry;
    }

    @XmlAttribute(name = "GDSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getGdsj() {
        return gdsj;
    }

    public void setGdsj(Date gdsj) {
        this.gdsj = gdsj;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
}
