/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import cn.gtmap.estateplat.utils.Charsets;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

public class WebUtil
extends WebUtils {
    public static final String UN_KNOWN = "unknown";
    public static final String USER_AGENT_HEADER = "user-agent";

    public static String getIP() {
        return WebUtil.getIP(WebUtil.getRequest());
    }

    public static String getIP(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"HttpServletRequest is null");
        String ip = request.getHeader("X-Requested-For");
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return StringUtils.isBlank((CharSequence)ip) ? null : ip.split(",")[0];
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static byte[] getRequestBytes(HttpServletRequest request) throws IOException {
        int readlen;
        int contentLength = request.getContentLength();
        if (contentLength < 0) {
            return null;
        }
        byte[] buffer = new byte[contentLength];
        for (int i = 0; i < contentLength && (readlen = request.getInputStream().read(buffer, i, contentLength - i)) != -1; i += readlen) {
        }
        return buffer;
    }

    public static String getRequestParamString(HttpServletRequest request) {
        try {
            return WebUtil.getRequestStr(request);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getRequestStr(HttpServletRequest request) throws IOException {
        String queryString = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            return new String(queryString.getBytes("ISO-8859-1"), Charsets.UTF8).replaceAll("&amp;", "&").replaceAll("%22", "\"");
        }
        return WebUtil.getRequestStr(request, WebUtil.getRequestBytes(request));
    }

    public static String getRequestStr(HttpServletRequest request, byte[] buffer) throws IOException {
        String str;
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = Charsets.UTF8;
        }
        if (StringUtils.isBlank((CharSequence)(str = new String(buffer, charEncoding).trim()))) {
            StringBuilder sb = new StringBuilder();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String key = (String)parameterNames.nextElement();
                String value = request.getParameter(key);
                WebUtil.appendBuilder(sb, key, "=", value, "&");
            }
            str = WebUtil.removeSuffix(sb.toString(), "&");
        }
        return str.replaceAll("&amp;", "&");
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)suffix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return StringUtils.substring((String)str2, (int)0, (int)(str2.length() - suffix.length()));
        }
        return str2;
    }
}

