package cn.gtmap.estateplat.core.support.spring;

import cn.gtmap.estateplat.core.support.fastjson.FastjsonView;
import cn.gtmap.estateplat.utils.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-7-2
 */
public class ResponseBodyHandlerExceptionResolver implements Ordered, HandlerExceptionResolver {
    public static final String KEY = "ex";
    public static final View VIEW = new FastjsonView(KEY);
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }

    @Override
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        logger.error("服务运行异常:", ex);
        logException(request,ex);
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            if (handlerMethod.getMethodAnnotation(ResponseBody.class) != null) {
                return new ModelAndView(VIEW, KEY, ExUtils.toMap(ex));
            }
        }
        return null;
    }

    public void logException(HttpServletRequest request, Exception ex) {
    }
}
