package cn.gtmap.estateplat.service.exchange;


import cn.gtmap.estateplat.model.exchange.transition.QzLxdzb;

import java.util.HashMap;
import java.util.List;

/**
 * 类型对照表接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2015/11/27
 */
public interface QzLxzdbService {
    /**
     * 根据类型名称和原类型代码获取新类型代码
     * @param lxmc
     * @param ylxdm
     * @return
     */
    public String getXlxdmByLxmcAndYlxdm(String lxmc, String ylxdm);

    /**
     * 根据类型名称和原类型名称获取新类型代码
     * @param lxmc
     * @param ylxmc
     * @return
     */
    public String getXlxdmByLxmcAndYlxmc(String lxmc, String ylxmc);

    /**
     * 根据类型名称和原类型代码获取新类型名称
     * @param lxmc
     * @param ylxdm
     * @return
     */
    public String getXlxmcByLxmcAndYlxdm(String lxmc, String ylxdm);

    /**
     * 根据类型名称和原类型名称获取新类型名称
     * @param lxmc
     * @param ylxmc
     * @return
     */
    public String getXlxmcByLxmcAndYlxmc(String lxmc, String ylxmc);

    /**
     * 根据类型名称和原类型代码获取原类型名称
     * @param lxmc
     * @param ylxdm
     * @return
     */
    public String getYlxmcByLxmcAndYlxdm(String lxmc, String ylxdm);

    /**
     * 根据类型名称和原类型名称获取原类型名称
     * @param lxmc
     * @param ylxmc
     * @return
     */
    public String getYlxmcByLxmcAndYlxmc(String lxmc, String ylxmc);

    /**
     * 根据类型名称和新类型代码获取新类型名称
     * @param lxmc
     * @param xlxdm
     * @return
     */
    public String getXlxmcByLxmcAndXlxdm(String lxmc, String xlxdm);

    /**
     * 根据类型名称和原类型名称获取原类型代码
     * @param lxmc
     * @param ylxmc
     * @return
     */
    public String getYlxdmByLxmcAndYlxmc(String lxmc, String ylxmc);

    /**
     * 通过类型代码获取收费对象名称
     * @return
     */
    public String getSfdxMcByLxdm(String dm);

    /**
     * 根据类型名称获取所有的类型对照表
     * @param lxmc
     * @return
     */
    public List<QzLxdzb> getQzLxdzbByLxmc(String lxmc);

    /**
     * 根据类型名称和新类型代码获取原类型代码
     * @param lxmc
     * @param xlxmc
     * @return
     */
    public String getYlxdmByLxmcAndXlxdm(String lxmc, String xlxmc);

}
