package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2021-01-18
 * @description
 */
public class JaxbDecimalThreeWithZeroAdapter extends XmlAdapter<String, BigDecimal> {

    @Override
    public BigDecimal unmarshal(String v) throws Exception {
        if (StringUtils.isNoneBlank(v)) {
            return new BigDecimal(v);
        }
        return null;
    }

    @Override
    public String marshal(BigDecimal v) throws Exception {
        String str = null;
        if (v != null) {
            DecimalFormat df = new DecimalFormat("0.000");
            str = df.format(v);
        }
        return str;
    }
}
