package cn.gtmap.estateplat.model.acceptance;/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2018/10/22
 * @description
 */

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
*@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
*@Description:买方核税表
*@Date 13:19 2018/10/22
*/
@Entity
@Table( name ="YCSL_HS_QLR" )
public class YcslHsQlr implements Serializable {
    /**
     * 核税ID
     */
    @Column(name = "HSID" )
    @Id
    private String hsid;
    /**
     * 项目id
     */
    @Column(name = "PROID" )
    private String proid;
    /**
     * 核定计税价格
     */
    @Column(name = "HSDJJG" )
    private Double hsdjjg;
    /**
     * 应征税额合计
     */
    @Column(name = "YZSEHJ" )
    private Double yzsehj;
    /**
     * 减免税额合计
     */
    @Column(name = "JMSEHJ" )
    private Double jmsehj;
    /**
     * 实际应征合计
     */
    @Column(name = "SJYZHJ" )
    private Double sjyzhj;
    /**
     * 完税状态 1 完税  0 未完税
     */
    @Column(name = "WSZT" )
    private String wszt;
    /**
     *税务id
     */
    @Column(name = "JYUUID" )
    private String jyuuid;
    /**
     *缴库状态
     */
    @Column(name = "JKZT" )
    private String jkzt;

    /**
     *纳税人识别号
     */
    @Column(name = "NSRSBH" )
    private String nsrsbh;

    /**
     * 缴税状态
     */
    @Column(name = "JSZT" )
    private String jszt;

    /**
     * 缴税二维码
     */
    @Column(name = "EWM" )
    private String ewm;

    /**
     * 电子税票号码
     */
    @Column(name = "DZSPHM" )
    private String dzsphm;

    /**
     * 凭证序号
     */
    @Column(name = "PZXH" )
    private String pzxh;


    public String getHsid() {
        return hsid;
    }

    public void setHsid(String hsid) {
        this.hsid = hsid;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Double getHsdjjg() {
        return hsdjjg;
    }

    public void setHsdjjg(Double hsdjjg) {
        this.hsdjjg = hsdjjg;
    }

    public Double getYzsehj() {
        return yzsehj;
    }

    public void setYzsehj(Double yzsehj) {
        this.yzsehj = yzsehj;
    }

    public Double getJmsehj() {
        return jmsehj;
    }

    public void setJmsehj(Double jmsehj) {
        this.jmsehj = jmsehj;
    }

    public Double getSjyzhj() {
        return sjyzhj;
    }

    public void setSjyzhj(Double sjyzhj) {
        this.sjyzhj = sjyzhj;
    }

    public String getWszt() {
        return wszt;
    }

    public void setWszt(String wszt) {
        this.wszt = wszt;
    }

    public String getJyuuid() {
        return jyuuid;
    }

    public void setJyuuid(String jyuuid) {
        this.jyuuid = jyuuid;
    }

    public String getJkzt() {
        return jkzt;
    }

    public void setJkzt(String jkzt) {
        this.jkzt = jkzt;
    }

    public String getNsrsbh() {
        return nsrsbh;
    }

    public void setNsrsbh(String nsrsbh) {
        this.nsrsbh = nsrsbh;
    }

    public String getJszt() {
        return jszt;
    }

    public void setJszt(String jszt) {
        this.jszt = jszt;
    }

    public String getEwm() {
        return ewm;
    }

    public void setEwm(String ewm) {
        this.ewm = ewm;
    }

    public String getDzsphm() {
        return dzsphm;
    }

    public void setDzsphm(String dzsphm) {
        this.dzsphm = dzsphm;
    }

    public String getPzxh() {
        return pzxh;
    }

    public void setPzxh(String pzxh) {
        this.pzxh = pzxh;
    }
}
