package cn.gtmap.estateplat.model.exchange.national.newStandard;

import cn.gtmap.estateplat.model.exchange.national.AccessData;
import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleFourAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleTwoAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 宗海基本信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTT_ZHJBXX")
public class KttZhjbxxNew implements Serializable, AccessData {
    final static String ysdm = "6001020000";//要素代码
    private Integer bsm;//标识码
    private String zhdm;//宗海代码
    private String bdcdyh;//不动产单元号
    private String zhtzm;//宗海特征码
    private String xmmc;//项目名称
    private String xmxz;//项目性质
    private Double yhzmj;//用海总面积
    private Double zhmj;//宗海面积
    private String db;//等别
    private Double zhax;//占海岸线
    private String yhlxa;//用海类型A
    private String yhlxb;//用海类型B
    private String yhwzsm;//用海位置说明
    private String hdmc;//海岛名称
    private String hddm;//海岛代码
    private String ydfw;//用岛范围
    private Double ydmj;//用岛面积
    private String hdwz;//海岛位置
    private String hdyt;//海岛用途
    private String zht;//宗海图
    private String dah;//档案号
    private String zt;//状态
    private String qxdm;//区县代码
    private Date djsj;//登记时间
    private String dbr;//登簿人
    private String fj;//附记
    private String djjgbm;//登记机构编码
    private String djjgmc;//登记机构名称
    private String jdh;//街道(乡、镇)
    private String jfh;//街坊（村）
    private String zh;//组
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    private String ydyhfl;//用地用海分类
    private String hdytmc;//海岛用途名称
    @XmlAttribute(name = "YDYHFL")
    public String getYdyhfl() {
        return ydyhfl;
    }

    public void setYdyhfl(String ydyhfl) {
        this.ydyhfl = ydyhfl;
    }
    @XmlAttribute(name = "HDYTMC")
    public String getHdytmc() {
        return hdytmc;
    }

    public void setHdytmc(String hdytmc) {
        this.hdytmc = hdytmc;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "BSM")
    public Integer getBsm() {
        return bsm;
    }

    public void setBsm(Integer bsm) {
        this.bsm = bsm;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "ZHDM")
    public String getZhdm() {
        return zhdm;
    }

    public void setZhdm(String zhdm) {
        this.zhdm = zhdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZHTZM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZhtzm() {
        return zhtzm;
    }

    public void setZhtzm(String zhtzm) {
        this.zhtzm = zhtzm;
    }

    @XmlAttribute(name = "XMMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    @XmlAttribute(name = "XMXZ")
    public String getXmxz() {
        return xmxz;
    }

    public void setXmxz(String xmxz) {
        this.xmxz = xmxz;
    }

    @XmlAttribute(name = "YHZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getYhzmj() {
        return yhzmj;
    }

    public void setYhzmj(Double yhzmj) {
        this.yhzmj = yhzmj;
    }

    @XmlAttribute(name = "ZHMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getZhmj() {
        return zhmj;
    }

    public void setZhmj(Double zhmj) {
        this.zhmj = zhmj;
    }

    @XmlAttribute(name = "DB")
    public String getDb() {
        return db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    @XmlAttribute(name = "ZHAX")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getZhax() {
        return zhax;
    }

    public void setZhax(Double zhax) {
        this.zhax = zhax;
    }

    @XmlAttribute(name = "YHLXA")
    public String getYhlxa() {
        return yhlxa;
    }

    public void setYhlxa(String yhlxa) {
        this.yhlxa = yhlxa;
    }

    @XmlAttribute(name = "YHLXB")
    public String getYhlxb() {
        return yhlxb;
    }

    public void setYhlxb(String yhlxb) {
        this.yhlxb = yhlxb;
    }

    @XmlAttribute(name = "YHWZSM")
    public String getYhwzsm() {
        return yhwzsm;
    }

    public void setYhwzsm(String yhwzsm) {
        this.yhwzsm = yhwzsm;
    }

    @XmlAttribute(name = "HDMC")
    public String getHdmc() {
        return hdmc;
    }

    public void setHdmc(String hdmc) {
        this.hdmc = hdmc;
    }

    @XmlAttribute(name = "HDDM")
    public String getHddm() {
        return hddm;
    }

    public void setHddm(String hddm) {
        this.hddm = hddm;
    }

    @XmlAttribute(name = "YDFW")
    public String getYdfw() {
        return ydfw;
    }

    public void setYdfw(String ydfw) {
        this.ydfw = ydfw;
    }

    @XmlAttribute(name = "YDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getYdmj() {
        return ydmj;
    }

    public void setYdmj(Double ydmj) {
        this.ydmj = ydmj;
    }

    @XmlAttribute(name = "HDWZ")
    public String getHdwz() {
        return hdwz;
    }

    public void setHdwz(String hdwz) {
        this.hdwz = hdwz;
    }

    @XmlAttribute(name = "HDYT")
    public String getHdyt() {
        return hdyt;
    }

    public void setHdyt(String hdyt) {
        this.hdyt = hdyt;
    }

    @XmlAttribute(name = "ZHT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZht() {
        return zht;
    }

    public void setZht(String zht) {
        this.zht = zht;
    }

    @XmlAttribute(name = "DAH")
    public String getDah() {
        return dah;
    }

    public void setDah(String dah) {
        this.dah = dah;
    }

    @XmlAttribute(name = "ZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "DBR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "DJJGBM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjgbm() {
        return djjgbm;
    }

    public void setDjjgbm(String djjgbm) {
        this.djjgbm = djjgbm;
    }

    @XmlAttribute(name = "DJJGMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjgmc() {
        return djjgmc;
    }

    public void setDjjgmc(String djjgmc) {
        this.djjgmc = djjgmc;
    }

    @XmlAttribute(name = "JDH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJdh() {
        return jdh;
    }

    public void setJdh(String jdh) {
        this.jdh = jdh;
    }

    @XmlAttribute(name = "JFH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJfh() {
        return jfh;
    }

    public void setJfh(String jfh) {
        this.jfh = jfh;
    }

    @XmlAttribute(name = "ZH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }
}
