package cn.gtmap.estateplat.model.exchange.share;

import com.alibaba.fastjson.annotation.JSONField;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlType;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018-1-12
 * @description 全城通办业务信息
 */
@Entity
@Table(name = "gx_qctb_ywxx")
@XmlType(propOrder = {"xmid", "slbh", "djlx", "ywbm","cjrmc", "cjsj", "slqxdm", "sqzsbs","sffbcz","wszt","dsxtywh","zslqfs","tzrxm","tzfs","tzrdh","tzryddh","tzrdzyj","tzrdz","bz","bdczh","bdczslx","fczh","fczslx","tdzh","tdzslx","bdcdyh"})
public class GxQctbYwxx {
    @Id
    private String xmid;//项目ID（主键)
    private String slbh;//受理编号
    private String cjrmc;//创建人名称
    @JSONField(format="yyyy-MM-dd HH:mm:ss.SSS")
    private Date cjsj;//创建时间
    private String djlx;//登记类型
    private String ywbm;//业务编码
    private String slqxdm;//受理区县代码
    private String sqzsbs;//申请证书板式(证书版式字典表)
    private String wszt;//完税状态(是否字典表)
    private String dsxtywh;//地税系统业务号
    private String zslqfs;//证书领取方式(领取方式字典表)
    private String tzrxm;//通知人姓名
    private String tzfs;//通知方式(通知方式字典表)
    private String tzrdh;//通知人电话
    private String tzryddh;//通知人移动电话
    private String tzrdzyj;//通知人电子邮件
    private String tzrdz;//通知人地址
    private String bz;//备注
    private String bdczh;//不动产权证号
    private String bdczslx;//不动产证书类型(证书类型字典表)
    private String fczh;//房产证号
    private String fczslx;//房产证书类型(证书类型字典表)
    private String tdzh;//土地证号
    private String tdzslx;//土地证书类型(证书类型字典表)
    private String bdcdyh;//不动产单元号
    private String sffbcz;//申请分别持证(是否字典表)

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getCjrmc() {
        return cjrmc;
    }

    public void setCjrmc(String cjrmc) {
        this.cjrmc = cjrmc;
    }

    public Date getCjsj() {
        return cjsj;
    }

    public void setCjsj(Date cjsj) {
        this.cjsj = cjsj;
    }

    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public String getYwbm() {
        return ywbm;
    }

    public void setYwbm(String ywbm) {
        this.ywbm = ywbm;
    }

    public String getSlqxdm() {
        return slqxdm;
    }

    public void setSlqxdm(String slqxdm) {
        this.slqxdm = slqxdm;
    }

    public String getSqzsbs() {
        return sqzsbs;
    }

    public void setSqzsbs(String sqzsbs) {
        this.sqzsbs = sqzsbs;
    }

    public String getWszt() {
        return wszt;
    }

    public void setWszt(String wszt) {
        this.wszt = wszt;
    }

    public String getDsxtywh() {
        return dsxtywh;
    }

    public void setDsxtywh(String dsxtywh) {
        this.dsxtywh = dsxtywh;
    }

    public String getZslqfs() {
        return zslqfs;
    }

    public void setZslqfs(String zslqfs) {
        this.zslqfs = zslqfs;
    }

    public String getTzrxm() {
        return tzrxm;
    }

    public void setTzrxm(String tzrxm) {
        this.tzrxm = tzrxm;
    }

    public String getTzfs() {
        return tzfs;
    }

    public void setTzfs(String tzfs) {
        this.tzfs = tzfs;
    }

    public String getTzrdh() {
        return tzrdh;
    }

    public void setTzrdh(String tzrdh) {
        this.tzrdh = tzrdh;
    }

    public String getTzryddh() {
        return tzryddh;
    }

    public void setTzryddh(String tzryddh) {
        this.tzryddh = tzryddh;
    }

    public String getTzrdzyj() {
        return tzrdzyj;
    }

    public void setTzrdzyj(String tzrdzyj) {
        this.tzrdzyj = tzrdzyj;
    }

    public String getTzrdz() {
        return tzrdz;
    }

    public void setTzrdz(String tzrdz) {
        this.tzrdz = tzrdz;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getBdczh() {
        return bdczh;
    }

    public void setBdczh(String bdczh) {
        this.bdczh = bdczh;
    }

    public String getBdczslx() {
        return bdczslx;
    }

    public void setBdczslx(String bdczslx) {
        this.bdczslx = bdczslx;
    }

    public String getFczh() {
        return fczh;
    }

    public void setFczh(String fczh) {
        this.fczh = fczh;
    }

    public String getFczslx() {
        return fczslx;
    }

    public void setFczslx(String fczslx) {
        this.fczslx = fczslx;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public String getTdzslx() {
        return tdzslx;
    }

    public void setTdzslx(String tdzslx) {
        this.tdzslx = tdzslx;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getSffbcz() {
        return sffbcz;
    }

    public void setSffbcz(String sffbcz) {
        this.sffbcz = sffbcz;
    }
}
