package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleThreeAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 逻辑幢信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTT_FW_LJZ")
public class KttFwLjz implements Serializable, AccessData {
    final static String ysdm = "6001030120";//要素代码
    private String ljzh;//逻辑幢号
    private String zrzh;//自然幢号
    private String mph;//门牌号
    private Double ycjzmj;//预测建筑面积
    private Double ycdxmj;//预测地下面积
    private Double ycqtmj;//预测其它面积
    private Double scjzmj;//实测建筑面积
    private Double scdxmj;//实测地下面积
    private Double scqtmj;//实测其它面积
    private Date jgrq;//竣工日期
    private String fwjg1;//房屋结构1
    private String fwjg2;//房屋结构2
    private String fwjg3;//房屋结构3
    private String jzwzt;//建筑物状态
    private String fwyt1;//房屋用途1
    private String fwyt2;//房屋用途2
    private String fwyt3;//房屋用途3
    private Integer zcs;//总层数
    private Integer dscs;//地上层数
    private Integer dxcs;//地下层数
    private String bz;//备注
    private String qxdm;//区县代码
    private String bdcdyh;//不动产单元号
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 逻辑幢编号
     */
    private String ljzbh;
    private String zddm;
    // 长春特殊需求
    private String ytmc;

    private String zrzbsm;//幢标识码
    private String pzyt;//批准用途
    private String sjyt;//实际用途
    @XmlAttribute(name="ZRZBSM")
    public String getZrzbsm() {
        return zrzbsm;
    }

    public void setZrzbsm(String zrzbsm) {
        this.zrzbsm = zrzbsm;
    }
    @XmlAttribute(name="PZYT")
    public String getPzyt() {
        return pzyt;
    }

    public void setPzyt(String pzyt) {
        this.pzyt = pzyt;
    }
    @XmlAttribute(name="SJYT")
    public String getSjyt() {
        return sjyt;
    }

    public void setSjyt(String sjyt) {
        this.sjyt = sjyt;
    }

    @XmlAttribute(name="YTMC")
    public String getYtmc()
    {
        return this.ytmc;
    }

    public void setYtmc(String ytmc) {
        this.ytmc = ytmc;
    }


    @XmlTransient
    public String getLjzbh() {
        return ljzbh;
    }

    public void setLjzbh(String ljzbh) {
        this.ljzbh = ljzbh;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
    @XmlAttribute(name = "LJZH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getLjzh() {
        return ljzh;
    }

    public void setLjzh(String ljzh) {
        this.ljzh = ljzh;
    }

    @XmlAttribute(name = "ZRZH")
    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "MPH")
    public String getMph() {
        return mph;
    }

    public void setMph(String mph) {
        this.mph = mph;
    }

    @XmlAttribute(name = "YCJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getYcjzmj() {
        return ycjzmj;
    }

    public void setYcjzmj(Double ycjzmj) {
        this.ycjzmj = ycjzmj;
    }

    @XmlAttribute(name = "YCDXMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getYcdxmj() {
        return ycdxmj;
    }

    public void setYcdxmj(Double ycdxmj) {
        this.ycdxmj = ycdxmj;
    }

    @XmlAttribute(name = "YCQTMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getYcqtmj() {
        return ycqtmj;
    }

    public void setYcqtmj(Double ycqtmj) {
        this.ycqtmj = ycqtmj;
    }

    @XmlAttribute(name = "SCJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScjzmj() {
        return scjzmj;
    }

    public void setScjzmj(Double scjzmj) {
        this.scjzmj = scjzmj;
    }

    @XmlAttribute(name = "SCDXMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScdxmj() {
        return scdxmj;
    }

    public void setScdxmj(Double scdxmj) {
        this.scdxmj = scdxmj;
    }

    @XmlAttribute(name = "SCQTMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScqtmj() {
        return scqtmj;
    }

    public void setScqtmj(Double scqtmj) {
        this.scqtmj = scqtmj;
    }

    @XmlAttribute(name = "JGRQ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getJgrq() {
        return jgrq;
    }

    public void setJgrq(Date jgrq) {
        this.jgrq = jgrq;
    }

    @XmlAttribute(name = "FWJG1")
    public String getFwjg1() {
        return fwjg1;
    }

    public void setFwjg1(String fwjg1) {
        this.fwjg1 = fwjg1;
    }

    @XmlAttribute(name = "FWJG2")
    public String getFwjg2() {
        return fwjg2;
    }

    public void setFwjg2(String fwjg2) {
        this.fwjg2 = fwjg2;
    }

    @XmlAttribute(name = "FWJG3")
    public String getFwjg3() {
        return fwjg3;
    }

    public void setFwjg3(String fwjg3) {
        this.fwjg3 = fwjg3;
    }

    @XmlAttribute(name = "JZWZT")
    public String getJzwzt() {
        return jzwzt;
    }

    public void setJzwzt(String jzwzt) {
        this.jzwzt = jzwzt;
    }

    @XmlAttribute(name = "FWYT1")
    public String getFwyt1() {
        return fwyt1;
    }

    public void setFwyt1(String fwyt1) {
        this.fwyt1 = fwyt1;
    }

    @XmlAttribute(name = "FWYT2")
    public String getFwyt2() {
        return fwyt2;
    }

    public void setFwyt2(String fwyt2) {
        this.fwyt2 = fwyt2;
    }

    @XmlAttribute(name = "FWYT3")
    public String getFwyt3() {
        return fwyt3;
    }

    public void setFwyt3(String fwyt3) {
        this.fwyt3 = fwyt3;
    }

    @XmlAttribute(name = "ZCS")
    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }

    @XmlAttribute(name = "DSCS")
    public Integer getDscs() {
        return dscs;
    }

    public void setDscs(Integer dscs) {
        this.dscs = dscs;
    }

    @XmlAttribute(name = "DXCS")
    public Integer getDxcs() {
        return dxcs;
    }

    public void setDxcs(Integer dxcs) {
        this.dxcs = dxcs;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlTransient
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZDDM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZddm() {
        return zddm;
    }

    public void setZddm(String zddm) {
        this.zddm = zddm;
    }
}
