package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 登记发证信息
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "DJF_DJ_FZ")
public class DjfDjFz implements Serializable, AccessData {
    final static String ysdm = "6004070000";//要素代码
    private String ywh;//业务号
    private String fzry;//发证人员
    private Date fzsj;//发证时间
    private String fzmc;//发证名称
    private Integer fzsl;//发证数量
    private String hfzsh;//核发证书号
    private String lzrxm;//领证人姓名
    private String lzrzjlb;//领证人证件类别
    private String lzrzjhm;//领证人证件号码
    private String lzrdh;//领证人电话
    private String lzrdz;//领证人地址
    private String lzryb;//领证人邮编
    private String bz;//备注
    private String qxdm;//区县代码
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;

    private String ysxlh;
    @XmlAttribute(name = "YSXLH")
    public String getYsxlh() {
        return ysxlh;
    }

    public void setYsxlh(String ysxlh) {
        this.ysxlh = ysxlh;
    }

    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }
    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "FZRY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFzry() {
        return fzry;
    }

    public void setFzry(String fzry) {
        this.fzry = fzry;
    }

    @XmlAttribute(name = "FZSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getFzsj() {
        return fzsj;
    }

    public void setFzsj(Date fzsj) {
        this.fzsj = fzsj;
    }

    @XmlAttribute(name = "FZMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFzmc() {
        return fzmc;
    }

    public void setFzmc(String fzmc) {
        this.fzmc = fzmc;
    }

    @XmlAttribute(name = "FZSL")
    public Integer getFzsl() {
        return fzsl;
    }

    public void setFzsl(Integer fzsl) {
        this.fzsl = fzsl;
    }

    @XmlAttribute(name = "HFZSH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getHfzsh() {
        return hfzsh;
    }

    public void setHfzsh(String hfzsh) {
        this.hfzsh = hfzsh;
    }

    @XmlAttribute(name = "LZRXM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getLzrxm() {
        return lzrxm;
    }

    public void setLzrxm(String lzrxm) {
        this.lzrxm = lzrxm;
    }

    @XmlAttribute(name = "LZRZJLB")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getLzrzjlb() {
        return lzrzjlb;
    }

    public void setLzrzjlb(String lzrzjlb) {
        this.lzrzjlb = lzrzjlb;
    }

    @XmlAttribute(name = "LZRZJHM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getLzrzjhm() {
        return lzrzjhm;
    }

    public void setLzrzjhm(String lzrzjhm) {
        this.lzrzjhm = lzrzjhm;
    }

    @XmlAttribute(name = "LZRDH")
    public String getLzrdh() {
        return lzrdh;
    }

    public void setLzrdh(String lzrdh) {
        this.lzrdh = lzrdh;
    }

    @XmlAttribute(name = "LZRDZ")
    public String getLzrdz() {
        return lzrdz;
    }

    public void setLzrdz(String lzrdz) {
        this.lzrdz = lzrdz;
    }

    @XmlAttribute(name = "LZRYB")
    public String getLzryb() {
        return lzryb;
    }

    public void setLzryb(String lzryb) {
        this.lzryb = lzryb;
    }

    @XmlAttribute(name = "BZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
}
