package cn.gtmap.estateplat.service.supplement;

import cn.gtmap.estateplat.model.server.core.Project;
import cn.gtmap.estateplat.model.server.core.Xmxx;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
 * @version V1.0, 2021/1/13
 * @description 不动产登记补充业务逻辑，如居住权等新增业务（通过标识码区分）的创建、初始化数据逻辑
 */
public interface SupplementaryProjectManageService {


    /**
     * @param project 项目信息
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @description 补充业务创建接口
     */
    String createProject(Xmxx project);

    /**
     * @param project 项目信息
     * @author <a href="mailto:xusong@gtmap.cn">xusong</a>
     * @description 补充业务创建接口
     */
    String createProject(String project);

    /**
     * 不动产单元项目验证
     * @param project
     * @author <a href="mailto:chengong@gtmap.cn">chengong</a>
     * @return
     */
    List<Map<String, Object>> checkMulXm(Project project);
}
