package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDoubleThreeAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 界址点信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTT_GY_JZD")
public class KttGyJzd implements Serializable, AccessData {
    final static String ysdm = "6001070000";//要素代码
    private Integer bsm;//标识码
    private String zdzhdm;//宗地宗海代码
    private String jzdh;//界址点号
    private Integer sxh;//顺序号
    private String jblx;//界标类型
    private String jzdlx;//界址点类型
    private BigDecimal xzbz;//X坐标值
    private BigDecimal yzbz;//Y坐标值
    private BigDecimal zzbz;//Z坐标值
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "BSM")
    public Integer getBsm() {
        return bsm;
    }

    public void setBsm(Integer bsm) {
        this.bsm = bsm;
    }

    @XmlAttribute(name = "ZDZHDM")
    public String getZdzhdm() {
        return zdzhdm;
    }

    public void setZdzhdm(String zdzhdm) {
        this.zdzhdm = zdzhdm;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "JZDH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJzdh() {
        return jzdh;
    }

    public void setJzdh(String jzdh) {
        this.jzdh = jzdh;
    }

    @XmlAttribute(name = "SXH")
    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    @XmlAttribute(name = "JBLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJblx() {
        return jblx;
    }

    public void setJblx(String jblx) {
        this.jblx = jblx;
    }

    @XmlAttribute(name = "JZDLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJzdlx() {
        return jzdlx;
    }

    public void setJzdlx(String jzdlx) {
        this.jzdlx = jzdlx;
    }

    @XmlAttribute(name = "XZBZ")
    public BigDecimal getXzbz() {
        return xzbz;
    }

    public void setXzbz(BigDecimal xzbz) {
        this.xzbz = xzbz;
    }

    @XmlAttribute(name = "YZBZ")
    public BigDecimal getYzbz() {
        return yzbz;
    }

    public void setYzbz(BigDecimal yzbz) {
        this.yzbz = yzbz;
    }

    @XmlAttribute(name = "ZZBZ")
    public BigDecimal getZzbz() {
        return zzbz;
    }

    public void setZzbz(BigDecimal zzbz) {
        this.zzbz = zzbz;
    }
}
