package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.national.DataModel;

import java.util.List;

/**
 * 国家级平台接入数据服务
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/11/16
 */
public interface NationalAccessDataService {
    /**
     * 根据业务号获取接入国家级平台的数据
     *
     * @param ywh 登记系统业务号
     * @return
     */
    <T> List<T> getAccessData(String ywh);

    /**
     * 将查询到的数据直接放入dataModel
     *
     * @param ywh       登记系统业务号
     * @param dataModel Model数据
     * @return
     */
    DataModel getAccessDataModel(String ywh, DataModel dataModel);

    /**
     * 获取到这个数据服务名称
     *
     * @return
     */
    String getAccessDataTagName();

    /**
     * @param ywh       登记系统业务号
     * @param dataModel Model数据
     * @param bdcdyh    不动产单元号 可为空
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @rerutn
     * @description 根据不动产单元号和业务号将查询到的数据直接放入dataModel
     */
    DataModel getAccessDataModel(String ywh, DataModel dataModel, String bdcdyh);

    /**
     * @param ywh       权利ID
     * @param bdcdyh    不动产单元号
     * @param dataModel
     * @return cn.gtmap.estateplat.model.exchange.national.DataModel
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 获取过度数据的 汇交数据实体
     */
    DataModel getGdAccessDataModel(String ywh, String bdcdyh, DataModel dataModel);


    /**
     * @param ywh       权利ID
     * @param bdcdyh    不动产单元号
     * @param dataModel
     * @return cn.gtmap.estateplat.model.exchange.national.DataModel
     * @author <a href="mailto:liyinqiao@gtmap.cn">jiangganzhi</a>
     * @description 获取一证多房过度数据的 汇交数据实体
     */
    DataModel getYzdfGdAccessDataModel(String ywh, String bdcdyh,String fwid, DataModel dataModel);
}
