package cn.gtmap.estateplat.core.support.spring;


import cn.gtmap.estateplat.core.support.mybatis.page.model.PageDefault;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/**
 * spring mvc分页参数解析处理类
 *
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/12/5
 */
public class DataPageableHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {
    /**
     * Whether the given {@linkplain MethodParameter method parameter} is
     * supported by this resolver.
     *
     * @param methodParameter the method parameter to check
     * @return {@code true} if this resolver supports the supplied parameter;
     * {@code false} otherwise
     */
    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(Pageable.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Integer rows;
        Integer page;
        PageDefault def = parameter.getParameterAnnotation(PageDefault.class);
        if (def != null) {
            rows = getParam(webRequest, "rows", def.prefix(), def.value());
            page = getParam(webRequest, "page", def.prefix(), def.offset());
        } else {
            rows = getParam(webRequest, "rows", null, null);
            page = getParam(webRequest, "page", null, null);
        }
        if (rows == null && page == null) {
            return new PageRequest(0, 20);
        } else {
            if (rows == null) {
                rows = 20;
            }
            if (page == null) {
                page = 0;
            } else {
                page -= 1;
            }
            return new PageRequest(page, rows);
        }
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty(prefix) ? name : prefix + "_" + name);
        return StringUtils.isNoneEmpty(s) ? Integer.valueOf(s) : def;
    }
}
