/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CompareXmlUtil {
    private static Map<String, String> pxMap;
    private static Map<String, String> qczdMap;
    private static Map<String, String> qcjdMap;
    private static String qczdJson;
    private static String qcjdJson;
    private static String pzJson;

    public static Map xml2map(String xmlStr, boolean needRootKey) throws DocumentException {
        CompareXmlUtil.getPxZd();
        CompareXmlUtil.getQcZd();
        CompareXmlUtil.getQcJd();
        Document doc = DocumentHelper.parseText((String)xmlStr);
        Element root = doc.getRootElement();
        Map map = CompareXmlUtil.xml2map(root, pxMap);
        if (root.elements().size() == 0 && root.attributes().size() == 0) {
            return map;
        }
        if (needRootKey) {
            TreeMap<String, Map> rootMap = new TreeMap<String, Map>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            rootMap.put(root.getName(), map);
            return rootMap;
        }
        return map;
    }

    private static Map xml2map(Element e, Map<String, String> pxMap) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                if (StringUtils.equals((CharSequence)iter.getQName().getName(), (CharSequence)"Head") || qcjdMap.containsKey(iter.getQName().getName())) continue;
                List<TreeMap> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map m = CompareXmlUtil.xml2map(iter, pxMap);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add((TreeMap)obj);
                            mapList.add((TreeMap)m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add((TreeMap)m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    TreeMap elementmap;
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add((TreeMap)obj);
                        if (iter.attributes() != null && iter.attributes().size() > 0) {
                            elementmap = CompareXmlUtil.elementmap(iter);
                            mapList.add(elementmap);
                        } else {
                            mapList.add((TreeMap)((Object)iter.getText()));
                        }
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        if (iter.attributes() != null && iter.attributes().size() > 0) {
                            elementmap = CompareXmlUtil.elementmap(iter);
                            mapList.add(elementmap);
                        } else {
                            mapList.add((TreeMap)((Object)iter.getText()));
                        }
                    }
                    String zd = "";
                    if (pxMap.containsKey(iter.getName())) {
                        zd = pxMap.get(iter.getName());
                        CompareXmlUtil.sortList(mapList, zd);
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
                if (iter.attributes() == null || iter.attributes().size() <= 0) continue;
                TreeMap elementmap = CompareXmlUtil.elementmap(iter);
                map.put(iter.getName(), elementmap);
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static List sortList(List list, String zd) {
        List<String> zdList = Arrays.asList(zd.split(","));
        if (zdList != null && zdList.size() > 0) {
            for (String pxzd : zdList) {
                CompareXmlUtil.sortListTreeMap(list, pxzd);
            }
        }
        return list;
    }

    private static List sortListTreeMap(List list, final String zd) {
        Collections.sort(list, new Comparator<TreeMap>(){

            @Override
            public int compare(TreeMap o1, TreeMap o2) {
                String str1 = "";
                str1 = o1.containsKey(zd) ? o1.get(zd).toString() : "";
                String str2 = "";
                str2 = o2.containsKey(zd) ? o2.get(zd).toString() : "";
                return str1.compareTo(str2);
            }
        });
        return list;
    }

    private static TreeMap elementmap(Element element) {
        TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        if (element.attributes() != null && element.attributes().size() > 0) {
            List attributeList = element.attributes();
            for (Attribute attribute : attributeList) {
                if (qczdMap.containsKey(attribute.getName())) continue;
                map.put(attribute.getName(), attribute.getValue());
            }
        }
        return map;
    }

    public static Document map2xml(Map<String, Object> map, String rootName) {
        Document doc = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement((String)rootName);
        doc.add(root);
        CompareXmlUtil.map2xml(map, root);
        return doc;
    }

    private static Element map2xml(Map<String, Object> map, Element body) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith("@")) {
                body.addAttribute(key.substring(1, key.length()), value.toString());
                continue;
            }
            if (key.equals("#text")) {
                body.setText(value.toString());
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (obj instanceof Map) {
                        Element subElement = body.addElement(key);
                        CompareXmlUtil.setAttributes((Map)list.get(i), subElement);
                        continue;
                    }
                    body.addElement(key).setText((String)list.get(i));
                }
                continue;
            }
            if (value instanceof Map) {
                Element subElement = body.addElement(key);
                CompareXmlUtil.setAttributes((Map)value, subElement);
                continue;
            }
            body.addElement(key).setText(value.toString());
        }
        return body;
    }

    public static Element setAttributes(Map map, Element subElement) {
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (subElement.getName().equals("Head") || entry.getValue() instanceof Map) {
                CompareXmlUtil.map2xml((Map<String, Object>)map, subElement);
                break;
            }
            if (!(entry.getValue() instanceof String)) continue;
            String integ = (String)entry.getValue();
            subElement.setAttributeValue(key, integ);
        }
        return subElement;
    }

    public static String chomp(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static Map<String, String> getPxZd() {
        if (MapUtils.isEmpty(pxMap)) {
            pxMap = Maps.newHashMap();
            List jsonObjectList = (List)JSON.parse((String)pzJson);
            if (jsonObjectList != null && jsonObjectList.size() > 0) {
                for (int i = 0; i < jsonObjectList.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)jsonObjectList.get(i);
                    pxMap.put(jsonObject.getString("jdmc"), jsonObject.getString("pxzd"));
                }
            }
        }
        return pxMap;
    }

    public static Map<String, String> getQcZd() {
        if (MapUtils.isEmpty(qczdMap)) {
            qczdMap = Maps.newHashMap();
            List jsonObjectList = (List)JSON.parse((String)qczdJson);
            if (jsonObjectList != null && jsonObjectList.size() > 0) {
                for (int i = 0; i < jsonObjectList.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)jsonObjectList.get(i);
                    qczdMap.put(jsonObject.getString("qczd"), jsonObject.getString("qczd"));
                }
            }
        }
        return qczdMap;
    }

    public static Map<String, String> getQcJd() {
        if (MapUtils.isEmpty(qcjdMap)) {
            qcjdMap = Maps.newHashMap();
            List jsonObjectList = (List)JSON.parse((String)qcjdJson);
            if (jsonObjectList != null && jsonObjectList.size() > 0) {
                for (int i = 0; i < jsonObjectList.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)jsonObjectList.get(i);
                    qcjdMap.put(jsonObject.getString("qcjd"), jsonObject.getString("qcjd"));
                }
            }
        }
        return qcjdMap;
    }

    static {
        qczdJson = "[{\"qczd\":\"BSM\"},{\"qczd\":\"QZYSXLH\"},{\"qczd\":\"YWRZJZL\"},{\"qczd\":\"YWRZJH\"},{\"qczd\":\"ZGZQSE\"},{\"qczd\":\"DFYWRZJZLDM\"},{\"qczd\":\"DFYWRZJZLMC\"},{\"qczd\":\"DYR\"}]";
        qcjdJson = "[{\"qcjd\":\"KTT_ZDJBXX\"},{\"qcjd\":\"KTF_ZDBHQK\"},{\"qcjd\":\"KTT_FW_ZRZ\"},{\"qcjd\":\"KTT_GY_JZX\"},{\"qcjd\":\"KTT_GY_JZD\"},{\"qcjd\":\"KTT_FW_LJZ\"},{\"qcjd\":\"KTT_FW_C\"},{\"qcjd\":\"KTT_FW_H\"},{\"qcjd\":\"DJF_DJ_SH\"},{\"qcjd\":\"DJF_DJ_SZ\"},{\"qcjd\":\"DJF_DJ_FZ\"},{\"qcjd\":\"DJF_DJ_GD\"},{\"qcjd\":\"DJF_DJ_SF\"},{\"qcjd\":\"DJT_DJ_SLSQ\"},{\"qcjd\":\"DJF_DJ_SJ\"},{\"qcjd\":\"ZD_K_103\"},{\"qcjd\":\"DJF_DJ_SQR\"}]";
        pzJson = "[{\"jdmc\":\"FJ_F_100\",\"pxzd\":\"FJMC\"},{\"jdmc\":\"DJF_DJ_SQR\",\"pxzd\":\"QLRMC\"},{\"jdmc\":\"DJF_DJ_GD\",\"pxzd\":\"GDSJ\"},{\"jdmc\":\"DJF_DJ_FZ\",\"pxzd\":\"HFZSH\"},{\"jdmc\":\"DJF_DJ_SZ\",\"pxzd\":\"SZZH\"},{\"jdmc\":\"DJF_DJ_SH\",\"pxzd\":\"JDMC,SXH\"},{\"jdmc\":\"DJF_DJ_SF\",\"pxzd\":\"SFKMMC\"},{\"jdmc\":\"DJF_DJ_SJ\",\"pxzd\":\"SJMC\"},{\"jdmc\":\"DJT_DJ_SLSQ\",\"pxzd\":\"DJDL,SLSJ\"},{\"jdmc\":\"ZD_K_103\",\"pxzd\":\"ZDX,XH\"},{\"jdmc\":\"ZTT_GY_QLR\",\"pxzd\":\"SXH,QLRMC\"},{\"jdmc\":\"KTT_GY_JZD\",\"pxzd\":\"JZDH\"},{\"jdmc\":\"KTT_GY_JZX\",\"pxzd\":\"JZXCD\"},{\"jdmc\":\"QLF_FW_FDCQ_DZ_XM\",\"pxzd\":\"ZH,XMMC\"},{\"jdmc\":\"KTT_FW_H\",\"pxzd\":\"ZL,SHBW\"},{\"jdmc\":\"KTT_FW_C\",\"pxzd\":\"ZRZH,CH,SJC,CJZMJ\"},{\"jdmc\":\"KTT_FW_LJZ\",\"pxzd\":\"ZRZH,LJZH,SCJZMJ,YCJZMJ\"},{\"jdmc\":\"KTT_FW_ZRZ\",\"pxzd\":\"ZRZH,SCJZMJ,YCJZMJ\"},{\"jdmc\":\"KTF_ZH_YHZK\",\"pxzd\":\"YHFS,YHMJ,JTYT\"},{\"jdmc\":\"KTF_ZH_YHYDZB\",\"pxzd\":\"XH\"},{\"jdmc\":\"KTF_ZHBHQK\",\"pxzd\":\"DJSJ\"},{\"jdmc\":\"ZH_K_105\",\"pxzd\":\"ZDX,XH\"}]";
    }
}

