package cn.gtmap.estateplat.model.acceptance;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2018/9/18
 * @description 收费信息表
 */
@Entity
@Table(name = "YCSL_SFXX")
public class YcslSfxx implements Serializable {
    /**
     * 主键
     */
    @Column(name = "SFXXID")
    @Id
    private String sfxxid;

    /**
     * 项目id
     */
    @Column(name = "PROID")
    private String proid;

    /**
     * 合计
     */
    @Column(name = "HJ")
    private Double hj;


    /**
     * 收缴日期
     */
    @Column(name = "SJRQ")
    private Date sjrq;


    /**
     * 发票号
     */
    @Column(name = "FPH")
    private String fph;

    /**
     * 收费状态
     */
    @Column(name = "SFZT")
    private String sfzt;

    /**
     * 收款人
     */
    @Column(name = "SKR")
    private String skr;


    /**
     * 收款人账号
     */
    @Column(name = "SKRZH")
    private String skrzh;


    /**
     * 收款人开户银行
     */
    @Column(name = "SKRKHYH")
    private String skrkhyh;


    /**
     * 交款人
     */
    @Column(name = "JKR")
    private String jkr;

    /**
     * 交款人账号
     */
    @Column(name = "JKRZH")
    private String jkrzh;

    /**
     * 交款人开户银行
     */
    @Column(name = "JKRKHYH")
    private String jkrkhyh;

    /**
     * 权利人类型
     */
    @Column(name = "QLRLX")
    private String qlrlx;

    /**
     * 权利人类型
     */
    @Column(name = "BZ")
    private String bz;

    /**
     * 缴库状态
     */
    @Column(name = "JKZT")
    private String jkzt;

    /**
     * 缴款识别码
     */
    @Column(name = "JKSBM")
    private String jksbm;

    /**
     *
     */
    @Column(name = "DDBH")
    private String ddbh;

    /**
     * 缴费地址
     */
    @Column(name = "JFDZ")
    private String jfdz;

    public String getSfxxid() {
        return sfxxid;
    }

    public void setSfxxid(String sfxxid) {
        this.sfxxid = sfxxid;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Double getHj() {
        return hj;
    }

    public void setHj(Double hj) {
        this.hj = hj;
    }

    public Date getSjrq() {
        return sjrq;
    }

    public void setSjrq(Date sjrq) {
        this.sjrq = sjrq;
    }

    public String getFph() {
        return fph;
    }

    public void setFph(String fph) {
        this.fph = fph;
    }

    public String getSfzt() {
        return sfzt;
    }

    public void setSfzt(String sfzt) {
        this.sfzt = sfzt;
    }

    public String getSkr() {
        return skr;
    }

    public void setSkr(String skr) {
        this.skr = skr;
    }

    public String getSkrzh() {
        return skrzh;
    }

    public void setSkrzh(String skrzh) {
        this.skrzh = skrzh;
    }

    public String getSkrkhyh() {
        return skrkhyh;
    }

    public void setSkrkhyh(String skrkhyh) {
        this.skrkhyh = skrkhyh;
    }

    public String getJkr() {
        return jkr;
    }

    public void setJkr(String jkr) {
        this.jkr = jkr;
    }

    public String getJkrzh() {
        return jkrzh;
    }

    public void setJkrzh(String jkrzh) {
        this.jkrzh = jkrzh;
    }

    public String getJkrkhyh() {
        return jkrkhyh;
    }

    public void setJkrkhyh(String jkrkhyh) {
        this.jkrkhyh = jkrkhyh;
    }

    public String getQlrlx() {
        return qlrlx;
    }

    public void setQlrlx(String qlrlx) {
        this.qlrlx = qlrlx;
    }


    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getJkzt() {
        return jkzt;
    }

    public void setJkzt(String jkzt) {
        this.jkzt = jkzt;
    }

    public String getJksbm() {
        return jksbm;
    }

    public void setJksbm(String jksbm) {
        this.jksbm = jksbm;
    }

    public String getDdbh() {
        return ddbh;
    }

    public void setDdbh(String ddbh) {
        this.ddbh = ddbh;
    }

    public String getJfdz() {
        return jfdz;
    }

    public void setJfdz(String jfdz) {
        this.jfdz = jfdz;
    }
}
