package cn.gtmap.estateplat.utils;

import org.apache.commons.lang3.StringUtils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.text.DecimalFormat;

public class JaxbDoubleTwoAdapter extends XmlAdapter<String, Double> {
    @Override
    public Double unmarshal(String v) throws Exception {
        if(StringUtils.isNoneBlank(v)){
            return Double.parseDouble(v);
        }
        return null;
    }

    @Override
    public String marshal(Double v) throws Exception {
        String str = null;
        if (v != null) {
            DecimalFormat df = new DecimalFormat("0.00");
            str = df.format(v);
        }
        return str;
    }
}
