package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbBigdecimalAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleFourAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 用海状况
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTF_ZH_YHZK")
public class KtfZhYhzk implements Serializable, AccessData {
    private String zhdm;//宗海代码
    private String yhfs;//用海方式
    private Double yhmj;//用海面积
    private String jtyt;//具体用途
    private Double syjes;//使用金额数
    private String qxdm;//区县代码

    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "ZHDM")
    public String getZhdm() {
        return zhdm;
    }

    public void setZhdm(String zhdm) {
        this.zhdm = zhdm;
    }

    @XmlAttribute(name = "YHFS")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getYhfs() {
        return yhfs;
    }

    public void setYhfs(String yhfs) {
        this.yhfs = yhfs;
    }

    @XmlAttribute(name = "YHMJ")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getYhmj() {
        return yhmj;
    }

    public void setYhmj(Double yhmj) {
        this.yhmj = yhmj;
    }

    @XmlAttribute(name = "JTYT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJtyt() {
        return jtyt;
    }

    public void setJtyt(String jtyt) {
        this.jtyt = jtyt;
    }

    @XmlAttribute(name = "SYJES")
    @XmlJavaTypeAdapter(JaxbDoubleFourAdapter.class)
    public Double getSyjes() {
        return syjes;
    }

    public void setSyjes(Double syjes) {
        this.syjes = syjes;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
}
