package cn.gtmap.estateplat.model.exchange.unidofrmity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 数据汇交响应表（试点）
 */
@Table(name = "province_access_sd")
public class ProvinceAccessSd {
    @Id
    @Column(name = "biz_msg_id")
    private String bizMsgID;//业务报文ID
    @Column(name = "asid")
    private String ASID;//接入标准ID
    private String areaCode;//行政区划编码
    private String recType;//业务编码
    private String rightType;//权利类型
    private String regType;//登记类型
    private Date createDate;//创建时间
    @Column(name = "rec_flow_id")
    private String recFlowID;//业务流水号
    @Column(name = "reg_org_id")
    private String regOrgID;//登记机构
    @Column(name = "parcel_id")
    private String parcelID;//宗地/宗海代码
    private String estateNum;//不动产单元号
    private String preEstateNum;//上次不动产单元号
    private String certCount;//不动产权证号码数量
    private String proofCount;//证明号码数量
    @Column(name = "pre_cert_id")
    private String preCertID;//上次不动产权证号/不动产登记证明号
    private Date accessDate;//接入时间

    //响应部分
    private String successFlag;//成功标识
    private String responseCode;//响应编码
    private String responseInfo;//报文响应信息
    @Column(name = "cert_id")
    private String certID;//配号
    @Column(name = "qr_code")
    private String QRCode;//防伪二维码
    private String additionalData;//附加信息
    private String additionalData2;//附加信息，扩展


    /**
     * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
     * @description 报文xml
     */
    private String xml;

    /**
     * @author <a href="mailto:zhuruijie@gtmap.cn">zhuruijie</a>
     * @description 二级成功标识
     */
    private String nationalSuccessFlag;
    /**
     * @author <a href="mailto:zhuruijie@gtmap.cn">zhuruijie</a>
     * @description 二级响应编码
     */
    private String nationalResponseCode;
    /**
     * @author <a href="mailto:zhuruijie@gtmap.cn">zhuruijie</a>
     * @description 二级报文响应信息
     */
    private String nationalResponseInfo;

    //汇交方式
    private String exchangeMode;

    public String getBizMsgID() {
        return bizMsgID;
    }

    public void setBizMsgID(String bizMsgID) {
        this.bizMsgID = bizMsgID;
    }

    public String getASID() {
        return ASID;
    }

    public void setASID(String ASID) {
        this.ASID = ASID;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getRecType() {
        return recType;
    }

    public void setRecType(String recType) {
        this.recType = recType;
    }

    public String getRightType() {
        return rightType;
    }

    public void setRightType(String rightType) {
        this.rightType = rightType;
    }

    public String getRegType() {
        return regType;
    }

    public void setRegType(String regType) {
        this.regType = regType;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getRecFlowID() {
        return recFlowID;
    }

    public void setRecFlowID(String recFlowID) {
        this.recFlowID = recFlowID;
    }

    public String getRegOrgID() {
        return regOrgID;
    }

    public void setRegOrgID(String regOrgID) {
        this.regOrgID = regOrgID;
    }

    public String getParcelID() {
        return parcelID;
    }

    public void setParcelID(String parcelID) {
        this.parcelID = parcelID;
    }

    public String getEstateNum() {
        return estateNum;
    }

    public void setEstateNum(String estateNum) {
        this.estateNum = estateNum;
    }

    public String getPreEstateNum() {
        return preEstateNum;
    }

    public void setPreEstateNum(String preEstateNum) {
        this.preEstateNum = preEstateNum;
    }

    public String getCertCount() {
        return certCount;
    }

    public void setCertCount(String certCount) {
        this.certCount = certCount;
    }

    public String getProofCount() {
        return proofCount;
    }

    public void setProofCount(String proofCount) {
        this.proofCount = proofCount;
    }

    public String getPreCertID() {
        return preCertID;
    }

    public void setPreCertID(String preCertID) {
        this.preCertID = preCertID;
    }

    public String getSuccessFlag() {
        return successFlag;
    }

    public void setSuccessFlag(String successFlag) {
        this.successFlag = successFlag;
    }

    public String getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseInfo() {
        return responseInfo;
    }

    public void setResponseInfo(String responseInfo) {
        this.responseInfo = responseInfo;
    }

    public String getCertID() {
        return certID;
    }

    public void setCertID(String certID) {
        this.certID = certID;
    }

    public String getQRCode() {
        return QRCode;
    }

    public void setQRCode(String QRCode) {
        this.QRCode = QRCode;
    }

    public String getAdditionalData() {
        return additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public String getAdditionalData2() {
        return additionalData2;
    }

    public void setAdditionalData2(String additionalData2) {
        this.additionalData2 = additionalData2;
    }

    public Date getAccessDate() {
        return accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    public String getXml() {
        return xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getNationalSuccessFlag() {
        return nationalSuccessFlag;
    }

    public void setNationalSuccessFlag(String nationalSuccessFlag) {
        this.nationalSuccessFlag = nationalSuccessFlag;
    }

    public String getNationalResponseCode() {
        return nationalResponseCode;
    }

    public void setNationalResponseCode(String nationalResponseCode) {
        this.nationalResponseCode = nationalResponseCode;
    }

    public String getNationalResponseInfo() {
        return nationalResponseInfo;
    }

    public void setNationalResponseInfo(String nationalResponseInfo) {
        this.nationalResponseInfo = nationalResponseInfo;
    }

    public String getExchangeMode() {
        return exchangeMode;
    }

    public void setExchangeMode(String exchangeMode) {
        this.exchangeMode = exchangeMode;
    }
}
