package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.*;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 自然幢信息
 * Created by xhc on 2015/11/19.
 */

@XmlRootElement(name = "KTT_FW_ZRZ")
public class KttFwZrz implements Serializable, AccessData {
    final static String ysdm = "6001030110";//要素代码
    private Integer bsm;//标识码
    private String bdcdyh;//不动产单元号
    private String zddm;//宗地代码
    private String zrzh;//自然幢号
    private String xmmc;//项目名称
    private String jzwmc;//建筑物名称
    private Date jgrq;//竣工日期
    private Double jzwgd;//建筑物高度
    private Double zzdmj;//幢占地面积
    private Double zydmj;//幢用地面积
    private Double ycjzmj;//预测建筑面积
    private Double scjzmj;//实测建筑面积
    private Integer zcs;//总层数
    private Integer dscs;//地上层数
    private Integer dxcs;//地下层数
    private Double dxsd;//地下深度
    private String ghyt;//规划用途
    private String fwjg;//房屋结构
    private Integer zts;//总套数
    private String jzwjbyt;//建筑物基本用途
    private String dah;//档案号
    private String bz;//备注
    private String zt;//状态
    private String qxdm;//区县代码
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "BSM")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getBsm() {
        return bsm;
    }

    public void setBsm(Integer bsm) {
        this.bsm = bsm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "ZDDM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZddm() {
        return zddm;
    }

    public void setZddm(String zddm) {
        this.zddm = zddm;
    }

    @XmlAttribute(name = "ZRZH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    @XmlAttribute(name = "XMMC")
    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    @XmlAttribute(name = "JZWMC")
    public String getJzwmc() {
        return jzwmc;
    }

    public void setJzwmc(String jzwmc) {
        this.jzwmc = jzwmc;
    }

    @XmlAttribute(name = "JGRQ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getJgrq() {
        return jgrq;
    }

    public void setJgrq(Date jgrq) {
        this.jgrq = jgrq;
    }

    @XmlAttribute(name = "JZWGD")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getJzwgd() {
        return jzwgd;
    }

    public void setJzwgd(Double jzwgd) {
        this.jzwgd = jzwgd;
    }

    @XmlAttribute(name = "ZZDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getZzdmj() {
        return zzdmj;
    }

    public void setZzdmj(Double zzdmj) {
        this.zzdmj = zzdmj;
    }

    @XmlAttribute(name = "ZYDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getZydmj() {
        return zydmj;
    }

    public void setZydmj(Double zydmj) {
        this.zydmj = zydmj;
    }

    @XmlAttribute(name = "YCJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getYcjzmj() {
        return ycjzmj;
    }

    public void setYcjzmj(Double ycjzmj) {
        this.ycjzmj = ycjzmj;
    }

    @XmlAttribute(name = "SCJZMJ")
    @XmlJavaTypeAdapter(JaxbDoubleThreeAdapter.class)
    public Double getScjzmj() {
        return scjzmj;
    }

    public void setScjzmj(Double scjzmj) {
        this.scjzmj = scjzmj;
    }

    @XmlAttribute(name = "ZCS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }

    @XmlAttribute(name = "DSCS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getDscs() {
        return dscs;
    }

    public void setDscs(Integer dscs) {
        this.dscs = dscs;
    }

    @XmlAttribute(name = "DXCS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getDxcs() {
        return dxcs;
    }

    public void setDxcs(Integer dxcs) {
        this.dxcs = dxcs;
    }

    @XmlAttribute(name = "DXSD")
    @XmlJavaTypeAdapter(JaxbDoubleTwoAdapter.class)
    public Double getDxsd() {
        return dxsd;
    }

    public void setDxsd(Double dxsd) {
        this.dxsd = dxsd;
    }

    @XmlAttribute(name = "GHYT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    @XmlAttribute(name = "FWJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFwjg() {
        return fwjg;
    }

    public void setFwjg(String fwjg) {
        this.fwjg = fwjg;
    }

    @XmlAttribute(name = "ZTS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getZts() {
        return zts;
    }

    public void setZts(Integer zts) {
        this.zts = zts;
    }

    @XmlAttribute(name = "JZWJBYT")
    public String getJzwjbyt() {
        return jzwjbyt;
    }

    public void setJzwjbyt(String jzwjbyt) {
        this.jzwjbyt = jzwjbyt;
    }

    @XmlAttribute(name = "DAH")
    public String getDah() {
        return dah;
    }

    public void setDah(String dah) {
        this.dah = dah;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "ZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }
}
