package cn.gtmap.estateplat.core.i18n;

import java.util.Locale;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 13-10-26
 */
public abstract class AbstractMessageProvider implements MessageProvider {

    @Override
    public String getMessage(String key) {
        return getMessage(key, null, null, null);
    }

    @Override
    public String getMessage(String key, Object[] args) {
        return getMessage(key, args, null, null);
    }

    @Override
    public String getMessage(String key, Object[] args, String defaultMessage) {
        return getMessage(key, args, defaultMessage, null);
    }

    @Override
    public abstract String getMessage(String key, Object[] args, String defaultMessage, Locale locale);
}
