package cn.gtmap.estateplat.utils;

import com.google.common.html.HtmlEscapers;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:yangxin@gtmap.cn">yangxin</a>
 * @version V1.0, 14-6-26
 */
public final class HtmlUtils {

    public static String escape(Object html) {
        if (html == null) {
            return StringUtils.EMPTY;
        }
        return HtmlEscapers.htmlEscaper().escape(html.toString());
    }

    public static String unescape(Object html) {
        if (html == null) {
            return StringUtils.EMPTY;
        }
        return StringEscapeUtils.unescapeHtml4(html.toString());
    }

    private HtmlUtils() {
    }
}
