package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.transition.QzHead;
import cn.gtmap.estateplat.model.exchange.transition.QzQlr;

import java.util.HashMap;
import java.util.List;

/**
 * 房屋、土地信息接口
 *
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 1.0, 2015/11/28
 */
public interface QzFwTdxxService {
    /**
     * 根据房产业务号和土地业务号获取房屋信息
     *
     * @param fwywh
     * @param tdywh
     * @return
     */
    public String getQzFwxx(String fwywh, String tdywh);

    /**
     * 根据土地业务号获取土地信息
     *
     * @param tdywh
     * @return
     */
    public String getQzTdxx(String tdywh);

    /**
     * zdd 根据业务号主键获取所有的过渡信息
     * @param ywh
     * @return 所有的过渡信息对象
     */
    QzHead queryQzData(String ywh);

    /**
     * zdd 根据受理受理号（收件号）获取所有的过渡信息
     * @param slh 统一受理号
     * @return 返回多个前置信息集合
     */
    List<QzHead> queryQzDataList(String slh);


}
