package cn.gtmap.estateplat.model.acceptance;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:xusong@gtmap.cn">xusong</a>
 * @version 1.0, 2020-03-20
 * @description: 一窗受理pos机缴税信息
 */
@Entity
@Table( name ="YCSL_POS_JSXX" )
public class YcslPosJsxx implements Serializable {

    private static final long serialVersionUID = 8994344782560712242L;

    /**
     * 缴税信息id
     */
    @Column(name = "JSXXID")
    @Id
    private String jsxxid;

    /**
     * 缴款人类型 1 为权利人 2 为义务人
     */
    @Column(name = "JKRLX")
    private String jkrlx;

    /**
     * 是否成功 1 为成功 0 为失败
     */
    @Column(name = "SUCCESS")
    private String success;

    /**
     * 原因
     */
    @Column(name = "REASON")
    private String reason;

    /**
     * pos机id
     */
    @Column(name = "TERMID")
    private String termid;

    /**
     * 交易时间
     */
    @Column(name = "TRADETIME")
    private Date tradetime;

    /**
     * 流水号
     */
    @Column(name = "TRACENO")
    private String traceno;

    /**
     * 票据号
     */
    @Column(name = "SEQNO")
    private String seqno;

    /**
     * 金额
     */
    @Column(name = "AMOUNT")
    private Double amount;

    /**
     * 款台号
     */
    @Column(name = "DESKTOPNO")
    private String desktopno;

    /**
     * 交易方式
     * 0：IST   1：DCC   2:微信   3：支付宝   4：银联二维码
     *
     */
    @Column(name = "TRANFLAG")
    private String tranflag;

    /**
     * 付款凭证
     */
    @Column(name = "PAYNO")
    private String payno;

    public String getTermid() {
        return termid;
    }

    public void setTermid(String termid) {
        this.termid = termid;
    }

    public Date getTradetime() {
        return tradetime;
    }

    public void setTradetime(Date tradetime) {
        this.tradetime = tradetime;
    }

    public String getTraceno() {
        return traceno;
    }

    public void setTraceno(String traceno) {
        this.traceno = traceno;
    }

    public String getSeqno() {
        return seqno;
    }

    public void setSeqno(String seqno) {
        this.seqno = seqno;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public String getDesktopno() {
        return desktopno;
    }

    public void setDesktopno(String desktopno) {
        this.desktopno = desktopno;
    }

    public String getTranflag() {
        return tranflag;
    }

    public void setTranflag(String tranflag) {
        this.tranflag = tranflag;
    }

    public String getPayno() {
        return payno;
    }

    public void setPayno(String payno) {
        this.payno = payno;
    }

    public String getJsxxid() {
        return jsxxid;
    }

    public void setJsxxid(String jsxxid) {
        this.jsxxid = jsxxid;
    }

    public String getJkrlx() {
        return jkrlx;
    }

    public void setJkrlx(String jkrlx) {
        this.jkrlx = jkrlx;
    }

    public String getSuccess() {
        return success;
    }

    public void setSuccess(String success) {
        this.success = success;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}
