package cn.gtmap.estateplat.model.server.core;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 不动产登记证书（证明）
 *
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/11/1
 */
@Table(name = "bdc_zs")
public class BdcZs implements Serializable {
    @Id
    private String zsid; //证书Id

    private String bdcqzh;//不动产权证号

    private String zhlsh;//证号流水号

    private String nf;//年份

    private String czr;//持证人

    private Date czrq;//持证日期

    private String zslx;//证书类型

    private String bh;//编号

    private String qlqtzk;//权利其他状况

    private String dwdm;//单位代码

    private String sqsjc;//省区市简称

    private String szsxqc;//所在市县全称

    private String zstype;//证书类型

    private Date fzrq;//发证日期

    private String szrid;//缮证人ID

    private String szr;//缮证人

    private Date szrq;//缮证日期

    private String lzrzjzl;//领证人证件种类

    private String lzrzjh;//领证人证件号

    private Date lzrq;//领证日期

    private String fzr;//发证人

    private String lzr;//领证人

    private String lzrid;//领证人ID

    private String czrid;//持证人id

    private String dyzt;//打印状态

    private String ewmnr;//二维码内容

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 证书附记
     */
    private String fj;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 不动产单元号
     */
    private String bdcdyh;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 坐落
     */
    private String zl;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 证明权利或事项
     */
    private String zmqlsx;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 权利人
     */
    private String qlr;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 义务人
     */
    private String ywr;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 共有情况
     */
    private String gyqk;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 权利类型
     */
    private String qllx;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 权利性质
     */
    private String qlxz;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 用途
     */
    private String yt;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 面积
     */
    private String mj;
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 使用期限
     */
    private String syqx;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 允许打印时间
     */
    private Date yxdysj;

    /**
     * @author <a href="mailto:houqizheng@gtmap.cn">hqz</a>
     * @description 提示信息
     */
    private String tsxx;
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 打印次数
     */
    private Integer dycs;


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description bdc_zs表增加冗余字段qlrzjzl、qlrzjh、ywrzjzl、ywrzjh
     */
    private String qlrzjzl; //权利人证件种类

    private String qlrzjh; //权利人证件号

    private String ywrzjzl; //义务人证件种类

    private String ywrzjh; //义务人证件号
    private String qszt; //权属状态
    private String bdcqzhjc; //不动产权证号简称
    private String sqlxdm; //申请类型代码
    private String sqlxmc; //申请类型名称
    private String gybdcqzh;//共用不动产权证号
    private String sfsyyz;//是否使用印章
    private String sbbh;//设备编号
    private String zzbs;//证照标识
    private String dzzd;//打证终端 （0或空为局方人员，1为自助打证机）
    private String zzqzbs;//证照标识

    public String getZzqzbs() {
        return zzqzbs;
    }

    public void setZzqzbs(String zzqzbs) {
        this.zzqzbs = zzqzbs;
    }

    public String getQlrzjzl() {
        return qlrzjzl;
    }

    public void setQlrzjzl(String qlrzjzl) {
        this.qlrzjzl = qlrzjzl;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getYwrzjzl() {
        return ywrzjzl;
    }

    public void setYwrzjzl(String ywrzjzl) {
        this.ywrzjzl = ywrzjzl;
    }

    public String getYwrzjh() {
        return ywrzjh;
    }

    public void setYwrzjh(String ywrzjh) {
        this.ywrzjh = ywrzjh;
    }

    public String getTsxx() {
        return tsxx;
    }

    public void setTsxx(String tsxx) {
        this.tsxx = tsxx;
    }

    public String getSzrid() {
        return szrid;
    }

    public void setSzrid(String szrid) {
        this.szrid = szrid;
    }

    public String getLzrzjzl() {
        return lzrzjzl;
    }

    public void setLzrzjzl(String lzrzjzl) {
        this.lzrzjzl = lzrzjzl;
    }

    public Date getLzrq() {
        return lzrq;
    }

    public void setLzrq(Date lzrq) {
        this.lzrq = lzrq;
    }

    public String getLzrid() {
        return lzrid;
    }

    public void setLzrid(String lzrid) {
        this.lzrid = lzrid;
    }

    public String getZsid() {
        return zsid;
    }

    public void setZsid(String zsid) {
        this.zsid = zsid;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getZhlsh() {
        return zhlsh;
    }

    public void setZhlsh(String zhlsh) {
        this.zhlsh = zhlsh;
    }

    public String getNf() {
        return nf;
    }

    public void setNf(String nf) {
        this.nf = nf;
    }

    public String getCzr() {
        return czr;
    }

    public void setCzr(String czr) {
        this.czr = czr;
    }

    public Date getCzrq() {
        return czrq;
    }

    public void setCzrq(Date czrq) {
        this.czrq = czrq;
    }

    public String getZslx() {
        return zslx;
    }

    public void setZslx(String zslx) {
        this.zslx = zslx;
    }

    public String getBh() {
        return bh;
    }

    public void setBh(String bh) {
        this.bh = bh;
    }

    public String getQlqtzk() {
        return qlqtzk;
    }

    public void setQlqtzk(String qlqtzk) {
        this.qlqtzk = qlqtzk;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getSqsjc() {
        return sqsjc;
    }

    public void setSqsjc(String sqsjc) {
        this.sqsjc = sqsjc;
    }

    public String getSzsxqc() {
        return szsxqc;
    }

    public void setSzsxqc(String szsxqc) {
        this.szsxqc = szsxqc;
    }

    public String getZstype() {
        return zstype;
    }

    public void setZstype(String zstype) {
        this.zstype = zstype;
    }

    public Date getFzrq() {
        return fzrq;
    }

    public void setFzrq(Date fzrq) {
        this.fzrq = fzrq;
    }

    public String getSzr() {
        return szr;
    }

    public void setSzr(String szr) {
        this.szr = szr;
    }

    public Date getSzrq() {
        return szrq;
    }

    public void setSzrq(Date szrq) {
        this.szrq = szrq;
    }

    public String getLzrzjh() {
        return lzrzjh;
    }

    public void setLzrzjh(String lzrzjh) {
        this.lzrzjh = lzrzjh;
    }

    public String getFzr() {
        return fzr;
    }

    public void setFzr(String fzr) {
        this.fzr = fzr;
    }

    public String getLzr() {
        return lzr;
    }

    public void setLzr(String lzr) {
        this.lzr = lzr;
    }

    public String getCzrid() {
        return czrid;
    }

    public void setCzrid(String czrid) {
        this.czrid = czrid;
    }

    public String getDyzt() {
        return dyzt;
    }

    public void setDyzt(String dyzt) {
        this.dyzt = dyzt;
    }

    public String getEwmnr() {
        return ewmnr;
    }

    public void setEwmnr(String ewmnr) {
        this.ewmnr = ewmnr;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getZmqlsx() {
        return zmqlsx;
    }

    public void setZmqlsx(String zmqlsx) {
        this.zmqlsx = zmqlsx;
    }

    public String getQlr() {
        return qlr;
    }

    public void setQlr(String qlr) {
        this.qlr = qlr;
    }

    public String getYwr() {
        return ywr;
    }

    public void setYwr(String ywr) {
        this.ywr = ywr;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    public String getMj() {
        return mj;
    }

    public void setMj(String mj) {
        this.mj = mj;
    }

    public String getSyqx() {
        return syqx;
    }

    public void setSyqx(String syqx) {
        this.syqx = syqx;
    }

    public Date getYxdysj() {
        return yxdysj;
    }

    public void setYxdysj(Date yxdysj) {
        this.yxdysj = yxdysj;
    }

    public Integer getDycs() {
        return dycs;
    }

    public void setDycs(Integer dycs) {
        this.dycs = dycs;
    }

    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }

    public String getBdcqzhjc() {
        return bdcqzhjc;
    }

    public void setBdcqzhjc(String bdcqzhjc) {
        this.bdcqzhjc = bdcqzhjc;
    }

    public String getSqlxdm() {
        return sqlxdm;
    }

    public void setSqlxdm(String sqlxdm) {
        this.sqlxdm = sqlxdm;
    }

    public String getSqlxmc() {
        return sqlxmc;
    }

    public void setSqlxmc(String sqlxmc) {
        this.sqlxmc = sqlxmc;
    }

    public String getGybdcqzh() {
        return gybdcqzh;
    }

    public void setGybdcqzh(String gybdcqzh) {
        this.gybdcqzh = gybdcqzh;
    }

    public String getSfsyyz() {
        return sfsyyz;
    }

    public void setSfsyyz(String sfsyyz) {
        this.sfsyyz = sfsyyz;
    }

    public String getSbbh() {
        return sbbh;
    }

    public void setSbbh(String sbbh) {
        this.sbbh = sbbh;
    }

    public String getZzbs() {
        return zzbs;
    }

    public void setZzbs(String zzbs) {
        this.zzbs = zzbs;
    }

    public String getDzzd() {
        return dzzd;
    }

    public void setDzzd(String dzzd) {
        this.dzzd = dzzd;
    }
}
