package cn.gtmap.estateplat.model.acceptance;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/9/3
 * @description
 */
@Entity
@Table(name = "YCSL_DYAQ")
public class YcslDyaq implements Serializable {
    /**
     * 权利ID
     */
    @Column(name = "QLID")
    @Id
    private String qlid;

    /**
     * 项目id
     */
    @Column(name = "PROID")
    private String proid;

    /**
     * 流程id
     */
    @Column(name = "WIID")
    private String wiid;

    /**
     * 被担保主债权数额
     */
    @Column(name = "BDBZZQSE")
    private Double bdbzzqse;

    /**
     * 最高债权确定事实
     */
    @Column(name = "ZGZQQDSS")
    private String zgzqqdss;

    /**
     * 最高债权确定数额
     */
    @Column(name = "ZGZQQDSE")
    private Double zgzqqdse;

    /**
     * 债务履行期限开始日期
     */
    @Column(name = "ZWLXQXKSRQ")
    private Date zwlxqxksrq;

    /**
     * 债务履行期限结束日期
     */
    @Column(name = "ZWLXQXJSRQ")
    private Date zwlxqxjsrq;

    /**
     * 评估价值
     */
    @Column(name = "PGJZ")
    private Double pgjz;

    /**
     * 抵押范围
     */
    @Column(name = "DYFW")
    private String dyfw;

    /**
     * 抵押方式(抵押方式字典表)
     */
    @Column(name = "DYFS")
    private String dyfs;

    /**
     * 抵押顺位
     */
    @Column(name = "DYSW")
    private String dysw;

    /**
     * 贷款方式(贷款方式字典表)
     */
    @Column(name = "DKFS")
    private String dkfs;

    /**
     * 是否按揭
     */
    @Column(name = "SFAJ")
    private String sfaj;

    /**
     * 附记
     */
    @Column(name = "FJ")
    private String fj;

    /**
     * 注销原因
     */
    @Column(name = "ZXYY")
    private String zxyy;

    public String getQlid() {
        return qlid;
    }

    public void setQlid(String qlid) {
        this.qlid = qlid;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public Double getBdbzzqse() {
        return bdbzzqse;
    }

    public void setBdbzzqse(Double bdbzzqse) {
        this.bdbzzqse = bdbzzqse;
    }

    public String getZgzqqdss() {
        return zgzqqdss;
    }

    public void setZgzqqdss(String zgzqqdss) {
        this.zgzqqdss = zgzqqdss;
    }

    public Double getZgzqqdse() {
        return zgzqqdse;
    }

    public void setZgzqqdse(Double zgzqqdse) {
        this.zgzqqdse = zgzqqdse;
    }

    public Date getZwlxqxksrq() {
        return zwlxqxksrq;
    }

    public void setZwlxqxksrq(Date zwlxqxksrq) {
        this.zwlxqxksrq = zwlxqxksrq;
    }

    public Date getZwlxqxjsrq() {
        return zwlxqxjsrq;
    }

    public void setZwlxqxjsrq(Date zwlxqxjsrq) {
        this.zwlxqxjsrq = zwlxqxjsrq;
    }

    public Double getPgjz() {
        return pgjz;
    }

    public void setPgjz(Double pgjz) {
        this.pgjz = pgjz;
    }

    public String getDyfw() {
        return dyfw;
    }

    public void setDyfw(String dyfw) {
        this.dyfw = dyfw;
    }

    public String getDyfs() {
        return dyfs;
    }

    public void setDyfs(String dyfs) {
        this.dyfs = dyfs;
    }

    public String getDysw() {
        return dysw;
    }

    public void setDysw(String dysw) {
        this.dysw = dysw;
    }

    public String getDkfs() {
        return dkfs;
    }

    public void setDkfs(String dkfs) {
        this.dkfs = dkfs;
    }

    public String getSfaj() {
        return sfaj;
    }

    public void setSfaj(String sfaj) {
        this.sfaj = sfaj;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getZxyy() {
        return zxyy;
    }

    public void setZxyy(String zxyy) {
        this.zxyy = zxyy;
    }
}
