package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbBigdecimalAdapter;
import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 林权
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "QLT_QL_LQ")
public class QltQlLq implements Serializable, AccessData {
    final static String ysdm = "6002010300";//要素代码
    private String bdcdyh;//不动产单元号
    private String ywh;//业务号
    private String qllx;//权利类型
    private String djlx;//登记类型
    private String djyy;//登记原因
    private String fbf;//发包方
    private Double syqmj;//使用权（承包）面积
    private Date ldsyqssj;//林地使用（承包）起始时间
    private Date ldsyjssj;//林地使用（承包）结束时间
    private String ldsyqxz;//林地所有权性质
    private String sllmsyqr1;//森林所有权人1
    private String sllmsyqr2;//森林所有权人2
    private String zysz;//主要树种
    private Integer zs;//株数
    private String lz;//林种
    private String qy;//起源
    private Integer zlnd;//造林年度
    private String lb;//林班
    private String xb;//小班
    private String xdm;//小地名
    private String bdcqzh;//不动产权证号
    private String qxdm;//区县代码
    private String djjg;//登记机构
    private String dbr;//登簿人
    private Date djsj;//登记时间
    private String fj;//附记
    private String qszt;//权属状态
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }
    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    @XmlAttribute(name = "QLLX")
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "DJLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    @XmlAttribute(name = "DJYY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    @XmlAttribute(name = "FBF")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getFbf() {
        return fbf;
    }

    public void setFbf(String fbf) {
        this.fbf = fbf;
    }

    @XmlAttribute(name = "SYQMJ")
    @XmlJavaTypeAdapter(JaxbBigdecimalAdapter.class)
    public Double getSyqmj() {
        return syqmj;
    }

    public void setSyqmj(Double syqmj) {
        this.syqmj = syqmj;
    }

    @XmlAttribute(name = "LDSYQSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getLdsyqssj() {
        return ldsyqssj;
    }

    public void setLdsyqssj(Date ldsyqssj) {
        this.ldsyqssj = ldsyqssj;
    }

    @XmlAttribute(name = "LDSYJSSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getLdsyjssj() {
        return ldsyjssj;
    }

    public void setLdsyjssj(Date ldsyjssj) {
        this.ldsyjssj = ldsyjssj;
    }

    @XmlAttribute(name = "LDSYQXZ")
    public String getLdsyqxz() {
        return ldsyqxz;
    }

    public void setLdsyqxz(String ldsyqxz) {
        this.ldsyqxz = ldsyqxz;
    }

    @XmlAttribute(name = "SLLMSYQR1")
    public String getSllmsyqr1() {
        return sllmsyqr1;
    }

    public void setSllmsyqr1(String sllmsyqr1) {
        this.sllmsyqr1 = sllmsyqr1;
    }

    @XmlAttribute(name = "SLLMSYQR2")
    public String getSllmsyqr2() {
        return sllmsyqr2;
    }

    public void setSllmsyqr2(String sllmsyqr2) {
        this.sllmsyqr2 = sllmsyqr2;
    }

    @XmlAttribute(name = "ZYSZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZysz() {
        return zysz;
    }

    public void setZysz(String zysz) {
        this.zysz = zysz;
    }

    @XmlAttribute(name = "ZS")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getZs() {
        return zs;
    }

    public void setZs(Integer zs) {
        this.zs = zs;
    }

    @XmlAttribute(name = "LZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getLz() {
        return lz;
    }

    public void setLz(String lz) {
        this.lz = lz;
    }

    @XmlAttribute(name = "QY")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQy() {
        return qy;
    }

    public void setQy(String qy) {
        this.qy = qy;
    }

    @XmlAttribute(name = "ZLND")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getZlnd() {
        return zlnd;
    }

    public void setZlnd(Integer zlnd) {
        this.zlnd = zlnd;
    }

    @XmlAttribute(name = "LB")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getLb() {
        return lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    @XmlAttribute(name = "XB")
    public String getXb() {
        return xb;
    }

    public void setXb(String xb) {
        this.xb = xb;
    }

    @XmlAttribute(name = "XDM")
    public String getXdm() {
        return xdm;
    }

    public void setXdm(String xdm) {
        this.xdm = xdm;
    }

    @XmlAttribute(name = "BDCQZH")
    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJJG")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    @XmlAttribute(name = "DBR")
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }
}
