package cn.gtmap.estateplat.utils;

import com.gtis.config.AppConfig;
import org.springframework.stereotype.Service;
import org.springframework.util.PropertyPlaceholderHelper;

import java.util.Properties;

/**
 * 平台或者文件中心的接口
 *
 * @author <a href="mailto: lijian@gtmap.cn">lj</a>
 * @version 1.0 15-11-22
 */
@Service("platformUtil")
public class PlatformUtil {
    /**
     * zdd 将字符串中的opt参数替换为实际值
     *
     * @param url
     * @return
     */
    public String initOptProperties(String url) {
        if (url != null) {
            PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
            Properties properties = new Properties();
            properties.putAll(AppConfig.getProperties());
            url = propertyPlaceholderHelper.replacePlaceholders(url, properties);
        }

        return url;
    }
}
