package cn.gtmap.estateplat.utils;


import io.jsonwebtoken.*;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.util.Date;
import java.util.Map;

/**
 * @author <a href=""mailto:lisongtao@gtmap.cn>lisongtao</a>
 * @version 1.0, 2018/5/3
 * @description
 */
public class JwtUtil {
    /**
     *
     * @param jsonWebToken   生成的token
     * @param base64Security 生成token时用的秘钥
     * @return
     */
    public static Claims parseJWT(String jsonWebToken, String base64Security){
        try {
            Claims claims =null;
            JwtParser jwtParser= Jwts.parser();
            if(StringUtils.isNotBlank(base64Security)){
                jwtParser.setSigningKey(base64Security.getBytes());
            }
            claims=jwtParser.parseClaimsJws(jsonWebToken).getBody();
            return claims;
        }catch(Exception ex){
            return null;
        }
    }

    /**
     * 生成token
     * @param claimMap 第二部分的参数map 可赋值用户等信息
     * @param signature 算法  默认 SignatureAlgorithm.HS256
     * @param TTLMillis  超时时间设置  单位毫秒
     * @param base64Security  秘钥
     * @return
     */
    public static String createJWT(Map<String,Object> claimMap, SignatureAlgorithm signature, long TTLMillis, String base64Security){

        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);

        //添加构成JWT第一部分Header的参数
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", "njgt");
        //循环添加jwt第二部分Payload的参数
        if(claimMap!=null && claimMap.size()>0){
            for(String key:claimMap.keySet()){
                builder.claim(key,claimMap.get(key));
            }
        }
        if(StringUtils.isNotBlank(base64Security)){
            //算法赋值
            SignatureAlgorithm signatureAlgorithm =null;
            if(signature==null || signature== SignatureAlgorithm.NONE){
                signatureAlgorithm=SignatureAlgorithm.HS256;
            }else{
                signatureAlgorithm=signature;
            }
            //生成签名密钥
            byte[] apiKeySecretBytes = base64Security.getBytes();
            Key signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
            builder.signWith(signatureAlgorithm, signingKey);
        }

        //添加Token过期时间
        if (TTLMillis > 0) {
            long expMillis = nowMillis + TTLMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        //添加生成时间
        builder.setNotBefore(now);
        //生成JWT
        return builder.compact();
    }

}