package cn.gtmap.estateplat.service.commodity.house;

import cn.gtmap.estateplat.model.commodityHouse.contract.FcjyXjspfMmhtJk;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018-5-3
 * @description 房产交易新建商品房合同接口服务
 */
public interface FcjyXjspfHtRemoteService {
    /**
     * @param bdcdyh 不动产单元号
     * @param hid    户ID
     * @return 商品房价款
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据不动产单元号、户ID获取商品房价款
     */
    FcjyXjspfMmhtJk getFcjyXjspfMmhtJk(String bdcdyh, String hid);

    /**
     * @param bdcdyh 不动产单元号
     * @param hid    户ID
     * @return 商品房价款
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据不动产单元号、户ID获取商品房价款
     */
    String getFcjyXjspfMmhtJ(String bdcdyh, String hid);

    /**
     * @param htbh 合同编号
     * @return 不动产单元号
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据合同编号获取不动产单元号
     */
    String getBdcdyhByHtbh(String htbh);

    /**
     * @param bdcdyh 不动产单元号
     * @return 合同信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据合同信息获取不动产单元号
     */
    String getHtxxByBdcdyh(String bdcdyh);
}
