/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.core.support.spring;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.ex.Sourceable;
import cn.gtmap.estateplat.utils.ExUtils;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public class DataSourceProxy
extends LazyConnectionDataSourceProxy
implements FactoryBean<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceProxy.class);
    private boolean testConnect = true;

    public void setTestConnect(boolean testConnect) {
        this.testConnect = testConnect;
    }

    public DataSource getObject() throws Exception {
        return this;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        LOG.info("Db connect to [{}] with user {}", (Object)this.getProp("url"), (Object)this.getProp("username"));
        super.afterPropertiesSet();
        if (this.testConnect) {
            try {
                this.testConnect((DataSource)((Object)this));
            }
            catch (SQLException e) {
                ArrayList list = Lists.newArrayList();
                list.add("Driver -> " + this.getProp("driver"));
                list.add("Url -> " + this.getProp("url"));
                list.add("User -> " + this.getProp("username"));
                throw new ConnectException((Throwable)e, list);
            }
        }
    }

    private String getProp(String name) {
        return AppConfig.getPlaceholderValue((String)("db." + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnect(DataSource dataSource) throws SQLException {
        block16: {
            String driver = this.getProp("driver");
            String testSql = null;
            if ("com.mysql.jdbc.Driver".equals(driver)) {
                testSql = "SELECT 1";
            } else if ("org.postgresql.Driver".equals(driver)) {
                testSql = "SELECT NOW()";
            } else if ("com.ibm.db2.jdbc.app.DB2Driver".equals(driver)) {
                testSql = "SELECT CURRENT SQLID FROM SYSIBM.SYSDUMMY1";
            } else if ("oracle.jdbc.OracleDriver".equals(driver)) {
                testSql = "SELECT SYSDATE FROM DUAL";
            }
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                if (testSql != null) {
                    Statement ps = null;
                    try {
                        ps = connection.createStatement();
                        ps.execute(testSql);
                        break block16;
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                connection.getMetaData().getTables(null, null, "DSPING", new String[]{"TABLE"});
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    private class ConnectException
    extends AppException
    implements Sourceable {
        private static final long serialVersionUID = -6626317176869586154L;
        private List<String> source;

        private ConnectException(Throwable cause, List<String> source) {
            super(null, cause);
            this.source = source;
        }

        @Override
        public String getTitle() {
            return "Database connect error";
        }

        @Override
        public String getDescription() {
            return ExUtils.buildNestedMessage(this.getCause());
        }

        @Override
        public String getFile() {
            return "dbConfig";
        }

        @Override
        public List<String> getLines() {
            return this.source;
        }

        @Override
        public int getLineNumber() {
            return 2;
        }
    }
}

