/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.servlet.http.HttpServletRequest;

public class ClientInfoUtil {
    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getMACAddress(String ip) {
        String str = "";
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(new InputStreamReader(p.getInputStream(), "GBK"));
            for (int i = 1; i < 100; ++i) {
                str = input.readLine();
                if ((str = new String(str.getBytes(), "utf-8")) == null || str.indexOf("MAC") <= 1) continue;
                macAddress = str.substring(str.indexOf("=") + 2, str.length());
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return macAddress;
    }

    public static String getComputerName(String ip) {
        String computerName = "";
        String str = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(new InputStreamReader(p.getInputStream(), "GBK"));
            for (int i = 1; i < 100; ++i) {
                str = input.readLine();
                if ((str = new String(str.getBytes(), "utf-8")) == null || (str = str.trim().replaceAll("\\s{1,}", "")).indexOf("<") <= 1) continue;
                computerName = str.substring(0, str.indexOf("<"));
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return computerName;
    }
}

