package cn.gtmap.estateplat.service.commodity.house;

import cn.gtmap.estateplat.model.commodityHouse.projectManage.FcjyXjspfKfxm;
import cn.gtmap.estateplat.model.commodityHouse.projectManage.FcjyXjspfLjz;

import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018-3-21
 * @description 房产交易新建商品房接口服务
 */
public interface FcjyXjsfpRemoteService {
    /**
     * @param fdckfqybh 房地产开发企业编号
     * @return 新建商品房开发项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据房地产开发企业编号获取新建商品房开发项目
     */
    List<FcjyXjspfKfxm> getFcjyXjspfKfxmByFdckfqybh(String fdckfqybh);

    /**
     * @param xmid 项目ID
     * @return 新建商品逻辑幢
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据项目ID获取新建商品逻辑幢
     */
    List<FcjyXjspfLjz> getFcjyXjspfLjzByXmid(String xmid);

    /**
     * @param fdckfqybh 房地产开发企业编号
     * @return 新建商品逻辑幢
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据房地产开发企业编号获取新建商品逻辑幢
     */
    List<FcjyXjspfLjz> getFcjyXjspfLjzByFdckfqybh(String fdckfqybh);
}
