package cn.gtmap.estateplat.core.support.mybatis.page.repository;

import cn.gtmap.estateplat.core.support.mybatis.page.PaginationInterceptor;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.springframework.data.domain.Pageable;

import java.util.*;

/**
 * Date Created  2014-2-17
 *
 * @author loafer[zjh527@gmail.com]
 * @version 1.0
 */

public class Repository extends SqlSessionDaoSupport implements Repo {
    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        super.setSqlSessionTemplate(sqlSessionTemplate);
    }


    @Override
    public <T> T selectOne(String statement, Object parameter) {
        return this.getSqlSession().selectOne(statement, parameter);
    }

    @Override
    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSqlSession().selectList(statement, parameter);
    }

    @Override
    public <T> Page<T> selectPaging(String statement, Object parameter, int offset, int limit) {
        RowBounds rowBounds = new RowBounds(offset, limit);
        List<T> rows = this.getSqlSession().selectList(statement, parameter, rowBounds);

        int total = PaginationInterceptor.getPaginationTotal();

        Page<T> page = new PageImpl<T>(rows, offset + 1, total, limit);
        return page;
    }

    @Override
    public <T> Page<T> selectPaging(String statement, Object parameter, Pageable pageable) {
        RowBounds rowBounds = new RowBounds(pageable.getPageNumber(), pageable.getPageSize());
        List<T> rows = this.getSqlSession().selectList(statement, parameter, rowBounds);
        int total = PaginationInterceptor.getPaginationTotal();
        //lst  添加判断是否是没有查询总页数的(东北区域)  对查询总页数的原逻辑没影响
        //东北版新增拦截器赋值-1
        if(total==-1){
            if(rows.size()!=0 && rows.size() == pageable.getPageSize()){
                total=(pageable.getPageNumber()+1)*pageable.getPageSize() + 1;
            }else{
                total=(pageable.getPageNumber()+1)*pageable.getPageSize();
            }
        }
        Page<T> page = new PageImpl<T>(rows, total, pageable);
        return page;
    }
  
    
    /**
     *  查询zmd台账的数据  增加判断数据是否为 null
     * @author wuhongrui
     * @description
     * @param statement
     * @param parameter
     * @param pageable
     * @param flag
     * @return
     */
    @Override
    public <T> Page<T> selectPaging(String statement, Object parameter, Pageable pageable,String flag) {
    	RowBounds rowBounds = new RowBounds(pageable.getPageNumber(), pageable.getPageSize());
        List<T> rows = this.getSqlSession().selectList(statement, parameter, rowBounds);
        JSONObject obj=null;
        JSONArray arr = new JSONArray();
        for (Iterator iterator = rows.iterator(); iterator.hasNext();) {
			T t = (T) iterator.next();
			obj = new JSONObject((Map<String, Object>) t);
			arr.add(obj);
		}
        
        List<T> result= new ArrayList<T>();
        Map<Object,Object> map =null;
        
        
        for (int i = 0; i < arr.size(); i++) {
			JSONObject temp = arr.getJSONObject(i);
			 map = new HashMap<Object,Object>();
	        for (Map.Entry<String, Object> entry : temp.entrySet()) {
	        	
//	            System.out.println(entry.getKey() + ":" + entry.getValue());
	            if(null==entry.getValue()  || "".equals(entry.getValue())){
	            	map.put(entry.getKey(), "");
	            }
	            else{
	            	map.put((T)entry.getKey(), entry.getValue());
	            }
	           
	        }
	        result.add((T) map);
		}
        
//        if(!map.isEmpty() && map.size()>0){
//        	 result.add((T) map);
//        }
        int total = PaginationInterceptor.getPaginationTotal();
        Page<T> page = new PageImpl<T>(result, total, pageable);
        return page;
    }
    
    @Override
    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.getSqlSession().selectMap(statement, parameter, mapKey);
    }

    @Override
    public int insert(String statement, Object parameter) {
        return this.getSqlSession().insert(statement, parameter);
    }

    @Override
    public int update(String statement, Object parameter) {
        return this.getSqlSession().update(statement, parameter);
    }

    @Override
    public int delete(String statement, Object parameter) {
        return this.getSqlSession().delete(statement, parameter);
    }
}
