package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateYMDAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;

/*
 * @author <a href="mailto:yinyao@gtmap.cn">yinyao</a>
 * @version 1.0, 2017/7/25
 * @description 接入日志
 */
@XmlType(name = "accessLog", propOrder = {"areaCode", "areaName","accessDate","remark","registerInfo","accessInfo"})
@XmlRootElement(name = "AccessLog")
public class AccessLog {
    private String areaCode;//行政编码
    private String areaName;//行政名称
    private Date accessDate;//日期
    private String remark;//备注
    private RegisterInfo registerInfo;//登簿信息
    private AccessInfo accessInfo;//接入信息

    @XmlElement(name = "AreaCode")
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @XmlElement(name = "AreaName")
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    @XmlElement(name = "AccessDate")
    @XmlJavaTypeAdapter(JaxbDateYMDAdapter.class)
    public Date getAccessDate() {
        return accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    @XmlElement(name = "Remark")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @XmlElement(name = "RegisterInfo")
    public RegisterInfo getRegisterInfo() {
        return registerInfo;
    }

    public void setRegisterInfo(RegisterInfo registerInfo) {
        this.registerInfo = registerInfo;
    }

    @XmlElement(name = "AccessInfo")
    public AccessInfo getAccessInfo() {
        return accessInfo;
    }

    public void setAccessInfo(AccessInfo accessInfo) {
        this.accessInfo = accessInfo;
    }
}
