package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbBigdecimalAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;

/**
 * 宗海空间属性
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "ZH_K_105")
public class ZhK implements Serializable, AccessData {
    private String bdcdyh;//不动产单元号
    private Integer zdx;//子对象
    private Integer xh;//序号
    private Double xzb;//X坐标
    private Double yzb;//Y坐标

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZDX")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getZdx() {
        return zdx;
    }

    public void setZdx(Integer zdx) {
        this.zdx = zdx;
    }

    @XmlAttribute(name = "XH")
    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    @XmlAttribute(name = "XZB")
    @XmlJavaTypeAdapter(JaxbBigdecimalAdapter.class)
    public Double getXzb() {
        return xzb;
    }

    public void setXzb(Double xzb) {
        this.xzb = xzb;
    }

    @XmlAttribute(name = "YZB")
    @XmlJavaTypeAdapter(JaxbBigdecimalAdapter.class)
    public Double getYzb() {
        return yzb;
    }

    public void setYzb(Double yzb) {
        this.yzb = yzb;
    }
}
