package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 宗地空间属性
 * Created by xhc on 2015/11/20.
 */
@XmlRootElement(name = "ZD_K_103")
public class ZdK implements Serializable, AccessData {
    private String bdcdyh;//不动产单元号
    private Integer zdx;//子对象
    private Integer xh;//序号
    private BigDecimal xzb;//X坐标
    private BigDecimal yzb;//Y坐标

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZDX")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getZdx() {
        return zdx;
    }

    public void setZdx(Integer zdx) {
        this.zdx = zdx;
    }

    @XmlAttribute(name = "XH")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getXh() {
        return xh;
    }

    public void setXh(Integer xh) {
        this.xh = xh;
    }

    @XmlAttribute(name = "XZB")
    public BigDecimal getXzb() {
        return xzb;
    }

    public void setXzb(BigDecimal xzb) {
        this.xzb = xzb;
    }

    @XmlAttribute(name = "YZB")
    public BigDecimal getYzb() {
        return yzb;
    }

    public void setYzb(BigDecimal yzb) {
        this.yzb = yzb;
    }
}
