package cn.gtmap.estateplat.core.support.cas;


import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/10/18
 * @description httpClient模拟登录CAS服务
 */
@Service
public class CasService {
    @Autowired
    HttpClient httpClient;

    /**
     * @param username 用户名
     * @param password 密码
     * @return 是否成功
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description
     */
    public Boolean loginCas(final String username, final String password) throws IOException {
        final String casServerUrl = AppConfig.getCasUrl() + "/login";
        List<NameValuePair> parameters = Lists.newArrayList();
        parameters.add(new BasicNameValuePair("username", username));
        parameters.add(new BasicNameValuePair("password", password));
        parameters.add(new BasicNameValuePair("lt", getCasTicket(casServerUrl)));
        parameters.add(new BasicNameValuePair("execution", "e1s1"));
        parameters.add(new BasicNameValuePair("_eventId", "submit"));
        parameters.add(new BasicNameValuePair("submit", "Login"));
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(casServerUrl);
            post.setEntity(new UrlEncodedFormEntity(parameters, Charsets.UTF_8));
            response = ((CloseableHttpClient) httpClient).execute(post);
            if (response != null && HttpStatus.SC_OK == response.getStatusLine().getStatusCode()) {
                String responseText = EntityUtils.toString(response.getEntity());
                if (responseText.contains("登录成功"))
                    return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (response != null)
                response.close();
        }
        throw new RuntimeException("登录失败，请检查用户名和密码！");
    }

    /**
     * @param casLogoutUrl cas登出地址
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 登出cas
     */
    public void loginOutCas(final String casLogoutUrl) throws Exception {
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(casLogoutUrl);
            response = ((CloseableHttpClient) httpClient).execute(httpGet);
            if (response != null) {
                EntityUtils.consume(response.getEntity());
            }
        } finally {
            if (response != null)
                response.close();
        }
    }

    /**
     * 获取CAS ticket
     *
     * @param url cas服务地址
     * @return cas ticket
     * @throws IOException
     */
    private String getCasTicket(String url) throws IOException {
        BufferedReader bufferedReader = null;
        CloseableHttpResponse response = null;
        try {
            String result = "";
            HttpGet httpGet = new HttpGet(url);
            response = ((CloseableHttpClient) httpClient).execute(httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent(), Charsets.UTF_8));
                String tempLine = bufferedReader.readLine();
                String s = "<input type=\"hidden\" name=\"lt\" value=\"";
                while (tempLine != null) {
                    int index = tempLine.indexOf(s);
                    if (index != -1) {
                        String s1 = tempLine.substring(index + s.length());
                        int index1 = s1.indexOf("\"");
                        if (index1 != -1)
                            result = s1.substring(0, index1);
                    }
                    tempLine = bufferedReader.readLine();
                }
            }
            return result;
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bufferedReader != null)
                bufferedReader.close();
            if (response != null)
                response.close();
        }
        return "";
    }

    /**
     * @param
     * @return 是否已登录
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 是否已登录
     */
    private boolean isLogin() throws IOException {
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(AppConfig.getCasUrl() + "/login");
            response = ((CloseableHttpClient) httpClient).execute(httpGet);
            if (response != null && HttpStatus.SC_OK == response.getStatusLine().getStatusCode()) {
                String responseText = EntityUtils.toString(response.getEntity());
                if (responseText.contains("登录成功"))
                    return true;
                else
                    return false;
            } else
                return false;
        } finally {
            if (response != null)
                response.close();
        }
    }

    /**
     * @param url url地址
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description get请求url
     */
    public byte[] doGetRequest(final String url) throws IOException {
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            response = ((CloseableHttpClient) httpClient).execute(httpGet);
            if (response != null) {
                return EntityUtils.toByteArray(response.getEntity());
            } else
                return null;
        } finally {
            if (response != null)
                response.close();
        }
    }

    /**
     * @param url 页面地址
     * @return
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description post请求url
     */
    public byte[] doPostRequest(final String url, final List<NameValuePair> postParams) throws IOException {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(new UrlEncodedFormEntity(postParams, Charsets.UTF_8));
            response = ((CloseableHttpClient) httpClient).execute(httpPost);
            if (response != null) {
                return EntityUtils.toByteArray(response.getEntity());
            } else
                return null;
        } finally {
            if (response != null)
                response.close();
        }
    }
    /**
     * @param username 用户名
     * @param password 密码
     * @param idNo 身份证号
     * @return 是否成功
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description
     */
    public Boolean loginCasByIdNo(final String username, final String password, final String idNo) throws IOException {
        final String casServerUrl = AppConfig.getCasUrl() + "/login";
        List<NameValuePair> parameters = Lists.newArrayList();
        parameters.add(new BasicNameValuePair("username", username));
        parameters.add(new BasicNameValuePair("password", password));
        parameters.add(new BasicNameValuePair("idNo", idNo));
        parameters.add(new BasicNameValuePair("lt", getCasTicket(casServerUrl)));
        parameters.add(new BasicNameValuePair("execution", "e1s1"));
        parameters.add(new BasicNameValuePair("_eventId", "submit"));
        parameters.add(new BasicNameValuePair("submit", "Login"));
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(casServerUrl);
            post.setEntity(new UrlEncodedFormEntity(parameters, Charsets.UTF_8));
            response = ((CloseableHttpClient) httpClient).execute(post);
            if (response != null && HttpStatus.SC_OK == response.getStatusLine().getStatusCode()) {
                String responseText = EntityUtils.toString(response.getEntity());
                if (responseText.contains("登录成功"))
                    return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (response != null)
                response.close();
        }
        throw new RuntimeException("登录失败，请检查用户名和密码！");
    }
}
