package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 抵押物清单
 * Created by liwenshuo on 2017/2/6.
 */
@XmlRootElement(name = "QLF_QL_DYAQ_DYWQD")
public class QlfQlDyaqDywqd implements Serializable, AccessData {
    private String ysdm;//要素代码
    private String ywh;//业务号
    private int xh;//序号
    private String zl;//坐落
    private String yt;//用途
    private Double mj;//面积
    private String bdcdyh;//不动产单元号
    private String fwbh;//房屋编号
    private String qszt;//权属状态
    private String zxdyywh;//注销抵押业务号
    private String zxdyyy;//注销抵押原因
    private Date zxsj;//注销时间
    private Date updatetime;//更新时间
    private Date createtime;//入库时间


    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "YWH")
    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }



    @XmlAttribute(name = "QSZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }

    public void setYsdm(String ysdm) {
        this.ysdm = ysdm;
    }

    @XmlAttribute(name = "XH")
    public int getXh() {
        return xh;
    }

    public void setXh(int xh) {
        this.xh = xh;
    }

    @XmlAttribute(name = "ZL")
    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    @XmlAttribute(name = "YT")
    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    @XmlAttribute(name = "MJ")
    public Double getMj() {
        return mj;
    }

    public void setMj(Double mj) {
        this.mj = mj;
    }

    @XmlAttribute(name = "FWBH")
    public String getFwbh() {
        return fwbh;
    }

    public void setFwbh(String fwbh) {
        this.fwbh = fwbh;
    }

    @XmlAttribute(name = "ZXDYYWH")
    public String getZxdyywh() {
        return zxdyywh;
    }

    public void setZxdyywh(String zxdyywh) {
        this.zxdyywh = zxdyywh;
    }

    @XmlAttribute(name = "ZXDYYY")
    public String getZxdyyy() {
        return zxdyyy;
    }

    public void setZxdyyy(String zxdyyy) {
        this.zxdyyy = zxdyyy;
    }

    @XmlAttribute(name = "ZXDYSJ")
    public Date getZxsj() {
        return zxsj;
    }

    public void setZxsj(Date zxsj) {
        this.zxsj = zxsj;
    }
}
