package cn.gtmap.estateplat.service.exchange;

import cn.gtmap.estateplat.model.exchange.national.DataModel;

import java.util.List;

/**
 * 国家级平台接入数据服务
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/11/16
 */
public interface NationalAccessDataService {
    /**
     * 根据业务号获取接入国家级平台的数据
     *
     * @param ywh 登记系统业务号
     * @return
     */
    <T> List<T> getAccessData(String ywh);

    /**
     * 将查询到的数据直接放入dataModel
     *
     * @param ywh
     * @param dataModel
     * @return
     */
    DataModel getAccessDataModel(String ywh, DataModel dataModel);

    /**
     * 获取到这个数据服务名称
     *
     * @return
     */
    String getAccessDataTagName();
}
