package cn.gtmap.estateplat.model.exchange.national;

import cn.gtmap.estateplat.utils.JaxbDateAdapter;
import cn.gtmap.estateplat.utils.JaxbDoubleAdapter;
import cn.gtmap.estateplat.utils.JaxbIntegerAdapter;
import cn.gtmap.estateplat.utils.JaxbStringAdapter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * 宗地基本信息
 * Created by xhc on 2015/11/19.
 */
@XmlRootElement(name = "KTT_ZDJBXX")
public class KttZdjbxx implements Serializable, AccessData {

    final static String ysdm = "6001010000";//要素代码
    private Integer bsm;//标识码
    private String zddm;//宗地代码
    private String bdcdyh;//不动产单元号
    private String zdtzm;//宗地特征码
    private String zl;//坐落
    private Double zdmj;//宗地面积
    private String mjdw;//面积单位
    private String yt;//用途
    private String dj;//等级
    private Double jg;//价格
    private String qllx;//权利类型
    private String qlxz;//权利性质
    private String qlsdfs;//权利设定方式
    private Double rjl;//容积率
    private Double jzmd;//建筑密度
    private Double jzxg;//建筑限高
    private String zdszd;//宗地四至-东
    private String zdszn;//宗地四至-南
    private String zdszx;//宗地四至-西
    private String zdszb;//宗地四至-北
    private String zdt;//宗地图
    private String tfh;//图幅号
    private String djh;//地籍号
    private String dah;//档案号
    private String bz;//备注
    private String zt;//状态
    private String qxdm;//区县代码
    private Date djsj;//登记时间
    private String dbr;//登簿人
    private String fj;//附记
    private String djjgbm;//登记机构编码
    private String djjgmc;//登记机构名称
    private String jdh;//街道(乡、镇)
    private String jfh;//街坊（村）
    private String zh;//组
    /**  插入更新时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date updatetime;
    /**  插入创建时间
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @description
     */
    private Date createtime;
    @XmlTransient
    public Date getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    @XmlTransient
    public Date getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    @XmlAttribute(name = "JDH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJdh() {
        return jdh;
    }

    public void setJdh(String jdh) {
        this.jdh = jdh;
    }

    @XmlAttribute(name = "JFH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getJfh() {
        return jfh;
    }

    public void setJfh(String jfh) {
        this.jfh = jfh;
    }

    @XmlAttribute(name = "ZH")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }

    @XmlAttribute(name = "BSM")
    @XmlJavaTypeAdapter(JaxbIntegerAdapter.class)
    public Integer getBsm() {
        return bsm;
    }

    public void setBsm(Integer bsm) {
        this.bsm = bsm;
    }

    @XmlAttribute(name = "YSDM")
    public String getYsdm() {
        return ysdm;
    }

    @XmlAttribute(name = "ZDDM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZddm() {
        return zddm;
    }

    public void setZddm(String zddm) {
        this.zddm = zddm;
    }

    @XmlAttribute(name = "BDCDYH")
    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    @XmlAttribute(name = "ZDTZM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdtzm() {
        return zdtzm;
    }

    public void setZdtzm(String zdtzm) {
        this.zdtzm = zdtzm;
    }

    @XmlAttribute(name = "ZL")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    @XmlAttribute(name = "ZDMJ")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getZdmj() {
        return zdmj;
    }

    public void setZdmj(Double zdmj) {
        this.zdmj = zdmj;
    }

    @XmlAttribute(name = "MJDW")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    @XmlAttribute(name = "YT")
    public String getYt() {
        return yt;
    }

    public void setYt(String yt) {
        this.yt = yt;
    }

    @XmlAttribute(name = "DJ")
    public String getDj() {
        return dj;
    }

    public void setDj(String dj) {
        this.dj = dj;
    }

    @XmlAttribute(name = "JG")
    @XmlJavaTypeAdapter(JaxbDoubleAdapter.class)
    public Double getJg() {
        return jg;
    }

    public void setJg(Double jg) {
        this.jg = jg;
    }

    @XmlAttribute(name = "QLLX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    @XmlAttribute(name = "QLXZ")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    @XmlAttribute(name = "QLSDFS")
    public String getQlsdfs() {
        return qlsdfs;
    }

    public void setQlsdfs(String qlsdfs) {
        this.qlsdfs = qlsdfs;
    }

    @XmlAttribute(name = "RJL")
    public Double getRjl() {
        return rjl;
    }

    public void setRjl(Double rjl) {
        this.rjl = rjl;
    }

    @XmlAttribute(name = "JZMD")
    public Double getJzmd() {
        return jzmd;
    }

    public void setJzmd(Double jzmd) {
        this.jzmd = jzmd;
    }

    @XmlAttribute(name = "JZXG")
    public Double getJzxg() {
        return jzxg;
    }

    public void setJzxg(Double jzxg) {
        this.jzxg = jzxg;
    }

    @XmlAttribute(name = "ZDSZD")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdszd() {
        return zdszd;
    }

    public void setZdszd(String zdszd) {
        this.zdszd = zdszd;
    }

    @XmlAttribute(name = "ZDSZN")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdszn() {
        return zdszn;
    }

    public void setZdszn(String zdszn) {
        this.zdszn = zdszn;
    }

    @XmlAttribute(name = "ZDSZX")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdszx() {
        return zdszx;
    }

    public void setZdszx(String zdszx) {
        this.zdszx = zdszx;
    }

    @XmlAttribute(name = "ZDSZB")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdszb() {
        return zdszb;
    }

    public void setZdszb(String zdszb) {
        this.zdszb = zdszb;
    }

    @XmlAttribute(name = "ZDT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZdt() {
        return zdt;
    }

    public void setZdt(String zdt) {
        this.zdt = zdt;
    }

    @XmlAttribute(name = "TFH")
    public String getTfh() {
        return tfh;
    }

    public void setTfh(String tfh) {
        this.tfh = tfh;
    }

    @XmlAttribute(name = "DJH")
    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    @XmlAttribute(name = "DAH")
    public String getDah() {
        return dah;
    }

    public void setDah(String dah) {
        this.dah = dah;
    }

    @XmlAttribute(name = "BZ")
    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @XmlAttribute(name = "ZT")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt;
    }

    @XmlAttribute(name = "QXDM")
    public String getQxdm() {
        return qxdm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    @XmlAttribute(name = "DJSJ")
    @XmlJavaTypeAdapter(JaxbDateAdapter.class)
    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    @XmlAttribute(name = "DBR")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    @XmlAttribute(name = "FJ")
    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    @XmlAttribute(name = "DJJGBM")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjgbm() {
        return djjgbm;
    }

    public void setDjjgbm(String djjgbm) {
        this.djjgbm = djjgbm;
    }

    @XmlAttribute(name = "DJJGMC")
    @XmlJavaTypeAdapter(JaxbStringAdapter.class)
    public String getDjjgmc() {
        return djjgmc;
    }

    public void setDjjgmc(String djjgmc) {
        this.djjgmc = djjgmc;
    }
}
