/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.log;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.log.AuditLog;
import cn.gtmap.estateplat.log.AuditLogService;
import cn.gtmap.estateplat.model.server.core.BdcXtLog;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.data.domain.Pageable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.ui.Model;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Aspect
public class AuditLogAspect {
    private AuditLogService auditLogService;
    private SysUserService sysUserService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String ANONYMOUS_USER_ID = "-999";
    private static final String ANONYMOUS_USER_NAME = "\u533f\u540d\u7528\u6237";
    public static final String LOGIN_USER_IP = "login_user_ip";
    public static final String LOGIN_USER_MAC = "login_user_mac";
    public static final String LOGIN_USER_COMPUTERNAME = "login_user_computername";

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    @Pointcut(value="@annotation(cn.gtmap.estateplat.log.AuditLog)")
    public void auditLogServiceAspect() {
    }

    @Before(value="auditLogServiceAspect()")
    public void doBefore(JoinPoint joinPoint) {
        Method method = this.getMethod(joinPoint);
        AuditLog auditMethodLog = method.getAnnotation(AuditLog.class);
        String userId = StringUtils.isNotBlank((CharSequence)auditMethodLog.userId()) ? this.parseUserId(auditMethodLog.userId(), method, joinPoint.getArgs()) : null;
        this.auditLog(auditMethodLog.name(), this.getAuditContent(joinPoint, auditMethodLog), userId);
    }

    @After(value="auditLogServiceAspect()")
    public void doAfter(JoinPoint joinPoint) {
    }

    private void auditLog(String name, String content, String userId) {
        final BdcXtLog bdcXtLog = new BdcXtLog();
        bdcXtLog.setLogid(UUIDGenerator.generate());
        bdcXtLog.setCzrq(Calendar.getInstance().getTime());
        if (StringUtils.isNotBlank((CharSequence)SessionUtil.getCurrentUserId())) {
            bdcXtLog.setUserid(SessionUtil.getCurrentUserId());
            bdcXtLog.setUsername(SessionUtil.getCurrentUser().getUsername());
        } else if (StringUtils.isNotBlank((CharSequence)userId)) {
            PfUserVo pfUserVo;
            bdcXtLog.setUserid(userId);
            if (this.sysUserService != null && (pfUserVo = this.sysUserService.getUserVo(userId)) != null) {
                bdcXtLog.setUsername(pfUserVo.getUserName());
            }
        } else {
            bdcXtLog.setUserid(ANONYMOUS_USER_ID);
            bdcXtLog.setUsername(ANONYMOUS_USER_NAME);
        }
        bdcXtLog.setController(name);
        bdcXtLog.setParmjson(content);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                AuditLogAspect.this.auditLogService.saveAuditLog(bdcXtLog);
            }
        });
    }

    private AuditLog getMethodLog(JoinPoint joinPoint) {
        try {
            Method[] methods;
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            for (Method method : methods = targetClass.getMethods()) {
                Class<?>[] clazzs;
                if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
                return method.getAnnotation(AuditLog.class);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AppException(e.getMessage());
        }
        return null;
    }

    private String getAuditContent(JoinPoint joinPoint, AuditLog auditLog) {
        HashMap contentMap = Maps.newHashMap();
        String description = null;
        description = StringUtils.isNotBlank((CharSequence)auditLog.description()) ? auditLog.description() : "\u64cd\u4f5c\u5185\u5bb9";
        contentMap.put(description, this.filterArguments(joinPoint.getArgs()));
        return JSON.toJSONString((Object)contentMap);
    }

    private Object filterArguments(Object[] args) {
        ArrayList arguments = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof Model || arg instanceof Pageable || arg instanceof RedirectAttributes || arg instanceof HttpServletResponse || arg instanceof HttpServletRequest) continue;
            arguments.add(arg);
        }
        return arguments;
    }

    private String parseUserId(String userId, Method method, Object[] args) {
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = u.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paraNameArr.length; ++i) {
            context.setVariable(paraNameArr[i], args[i]);
        }
        return (String)parser.parseExpression(userId).getValue((EvaluationContext)context, String.class);
    }

    private Method getMethod(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        Class[] argTypes = new Class[joinPoint.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        Method method = null;
        try {
            method = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), argTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return method;
    }
}

